<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row row-gap-24">
                <div class="col-xxl-3">

                <div class="row">
                        <div class="col-lg-12">
                            <div>
                                <?php if(permissionCheck('backup.import')): ?>
                                    <form method="POST" action="<?php echo e(route('backup.import')); ?>"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <?php endif; ?>
                                        <div class="white-box">
                                            <div class="main-title">
                                                <h3 class="mb-20">
                                                    <?php echo app('translator')->get('common.Upload SQL File'); ?>
                                                </h3>
                                            </div>
                                            <div class="add-visitor">
                                                <div class="row  mt-25">
                                                    <div class="col-lg-12">

                                                        <div class="primary_input mb-15">
                                                            <div class="primary_file_uploader">
                                                                <input class="primary-input" type="text"
                                                                       id="placeholderFileOneName"
                                                                       placeholder="<?php echo e(__('setting.Browse file')); ?>"
                                                                       readonly="">
                                                                <button class="" type="button">
                                                                    <label class="primary-btn small fix-gr-bg"
                                                                           for="document_file_1"><?php echo e(__("common.Browse")); ?> </label>
                                                                    <input type="file" class="d-none" name="db_file"
                                                                           id="document_file_1">
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mt-40">
                                                    <div class="col-lg-12 text-center">
                                                        <button type="submit" class="primary-btn fix-gr-bg"
                                                                data-bs-toggle="tooltip"
                                                                title="">
                                                            <i class="ti-check"></i>
                                                            <?php echo e(__('common.Update')); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-9 ">
                    <div class="white-box">
                        <div class="row m-0">
                            <div class="col-lg-12 g-0">

                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"><?php echo app('translator')->get('common.Database Backup List'); ?></h3>

                                        <ul class="pull-right">
                                            <li>
                                                <?php if(permissionCheck('backup.create')): ?>
                                                    <a class="primary-btn radius_30px fix-gr-bg"
                                                       href="<?php echo e(route('backup.create')); ?>"><i
                                                            class="ti-plus"></i><?php echo e(__('common.Generate New Backup')); ?></a>
                                                <?php endif; ?>
                                            </li>
                                        </ul>


                                    </div>
                                </div>

                            </div>

                        </div>

                        <div class="row">
                            <div class="col-lg-12">

                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">
                                        <!-- table-responsive -->
                                        <div>
                                            <table class="table Crm_table_active3">
                                                <thead>
                                                <?php echo $__env->make('backend.partials.alertMessagePageLevelAll', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <tr>
                                                    <th width="30%"><?php echo app('translator')->get('common.SL'); ?></th>
                                                    <th width="30%"><?php echo app('translator')->get('common.Date'); ?></th>
                                                    <th width="40%"><?php echo app('translator')->get('common.File Name'); ?></th>
                                                    <th width="40%"><?php echo app('translator')->get('common.Download'); ?></th>
                                                    <th width="40%"><?php echo app('translator')->get('common.Action'); ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                <?php $__currentLoopData = $allBackup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e(++$key); ?></td>
                                                        <td class=""><?php echo e(substr($value, 0, 10)); ?></td>
                                                        <td><?php echo e(env('APP_NAME')."_db_$value".'.sql'); ?></td>
                                                        <td class="text-center">
                                                            <?php if(!config('app.demo_mode')): ?>
                                                                <a href="<?php echo e(asset('public/database-backup/'.$value.'/'.$value.'-dump.sql')); ?>"
                                                                   download="<?php echo e(env('APP_NAME')."_db_$value".'.sql'); ?>"><i
                                                                        class="fa fa-download"></i></a>
                                                            <?php else: ?>

                                                                <span style="cursor: pointer;" data-bs-toggle="tooltip"
                                                                      title="Restricted in demo mode"><i
                                                                        class="fa fa-download"></i>

                                                            </span></a>

                                                            <?php endif; ?>

                                                        </td>

                                                        <td>

                                                            <?php if(permissionCheck('backup.delete')): ?>
                                                                <span>
                                                                    <a onclick="confirm_modal('<?php echo e(route('backup.delete', $value)); ?>');"
                                                                       style="font-weight: 500;color: #ffff;font-family: 'Poppins', sans-serif;"
                                                                       href="#"
                                                                       class="primary-btn radius_30px fix-gr-bg"
                                                                    ><?php echo app('translator')->get('common.Delete'); ?></a>
                                                               </span>
                                                            <?php endif; ?>


                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php echo $__env->make('backend.partials.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/Modules/Backup/Resources/views/backup/index.blade.php ENDPATH**/ ?>