@extends('backend.master')

@section('mainContent')

    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-3">
                    <div class="white-box mb_30  student-details header-menu">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0"> {{!isset($edit)?trans('survey.Add New Group'):trans('survey.Update Group')}} </h3>
                                @if(isset($edit))
                                    @if (permissionCheck('survey.group.store'))
                                        <a href="{{route('survey.group.index')}}"
                                           class="primary-btn small fix-gr-bg ms-4" style="line-height: 25px;"
                                           title="{{__('courses.Add New')}}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>

                        @if (isset($edit))
                            @if (permissionCheck('survey.group.update'))
                                <form action="{{route('survey.group.update')}}" method="POST"
                                      id="category-form"
                                      name="category-form" enctype="multipart/form-data">
                                    <input type="hidden" name="id"
                                           value="{{$edit->id}}">
                                    @endif
                                    @else
                                        @if (permissionCheck('survey.group.store'))
                                            <form action="{{route('survey.group.store') }}" method="POST"
                                                  id="category-form" name="category-form"
                                                  enctype="multipart/form-data">
                                                @endif
                                                @endif
                                                @csrf

                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="nameInput">{{ __('common.Title') }}
                                                                <strong
                                                                    class="text-danger">*</strong></label>
                                                            <input name="title"
                                                                   id="nameInput"
                                                                   class="primary_input_field name {{ @$errors->has('title') ? ' is-invalid' : '' }}"
                                                                   placeholder="{{ __('common.Title') }}"
                                                                   type="text"
                                                                   value="{{isset($edit)?$edit->title:old('title')}}" {{$errors->has('title') ? 'autofocus' : ''}}>
                                                            @if ($errors->has('title'))
                                                                <span class="invalid-feedback d-block mb-10"
                                                                      role="alert">
                                                                <strong>{{ @$errors->first('title') }}</strong>
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="row">


                                                    @php
                                                        $tooltip = "";
                                                        if(permissionCheck('survey.group.store')){
                                                              $tooltip = "";
                                                          }else{
                                                              $tooltip = trans("courses.You have no permission to add");
                                                          }
                                                    @endphp
                                                    <div class="col-lg-12 text-center">
                                                        <div class="d-flex justify-content-center  ">
                                                            <button type="submit"
                                                                    class="primary-btn semi_large fix-gr-bg"
                                                                    data-bs-toggle="tooltip" title="{{@$tooltip}}"
                                                                    id="save_button_parent">
                                                                <i class=" fa fa-check "></i>
                                                                @if(!isset($edit))
                                                                    {{ __('common.Save') }}
                                                                @else
                                                                    {{ __('common.Update') }}
                                                                @endif
                                                            </button>


                                                        </div>
                                                    </div>
                                                </div>

                                            </form>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0"
                                    id="page_title">{{__('survey.Survey Group')}} {{__('common.List')}}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Title') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($groups as $key => $group)
                                            <tr>
                                                <td>{{++$key}}</td>
                                                <td>   {{@$group->title }}</td>

                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{@$group->id}}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{@$group->id}}">
                                                            @if (permissionCheck('survey.group.update'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{route('survey.group.edit',$group->id)}}">{{__('common.Edit')}}</a>
                                                            @endif
                                                            @if (permissionCheck('survey.group.delete'))
                                                                <a onclick="confirm_modal('{{route('survey.group.delete', $group->id)}}');"
                                                                   class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script type="application/javascript">

        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush

