<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{$order->package_code}} {{__('store.Invoice')}}</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap"
          rel="stylesheet">
    <style>
        .logo_div img {
            height: 100px;
        }

        body {
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            margin: 0;
            padding: 0;
        }

        table {
            border-collapse: collapse;
        }

        h1, h2, h3, h4, h5, h6 {
            margin: 0;
            color: #101010;
        }

        .invoice_wrapper {
            max-width: 1200px;
            margin: auto;
            background: #fff;
            padding: 20px;
        }

        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }

        .border_none {
            border: 0px solid transparent;
            border-top: 0px solid transparent !important;
        }

        .invoice_part_iner {
            background-color: #fff;
        }

        .table_border thead {
            background-color: #F6F8FA;
        }

        .table td, .table th {
            padding: 5px 0;
            vertical-align: top;
            border-top: 0 solid transparent;
            color: #101010;
        }

        .table td, .table th {
            padding: 5px 0;
            vertical-align: top;
            border-top: 0 solid transparent;
            color: #101010;
        }

        .table_border tr {
            border-bottom: 1px solid #101010 !important;
        }

        th p span, td p span {
            color: #212E40;
        }

        .table th {
            color: #101010;
            border: 1px solid #101010 !important;
        }

        p {
            font-size: 14px;
            color: #101010;
        }

        h5 {
            font-size: 12px;
            font-weight: 500;
        }

        h6 {
            font-size: 10px;
            font-weight: 300;
        }

        .mt_40 {
            margin-top: 40px;
        }

        .table_style th, .table_style td {
            padding: 20px;
        }

        .invoice_info_table td {
            font-size: 10px;
            padding: 0px;
        }

        .text_right {
            text-align: right;
        }

        .text_left {
            text-align: left !important;
        }

        .virtical_middle {
            vertical-align: middle !important;
        }

        .logo_img {
            max-width: 120px;
        }

        .logo_img img {
            width: 100%;
        }

        .border_bottom {
            border-bottom: 1px solid #000;
        }

        .line_grid {
            display: grid;
            grid-template-columns: 110px auto;
            grid-gap: 10px;
        }

        .line_grid span {
            display: flex;
            justify-content: space-between;
        }

        .line_grid2 {
            display: grid;
            grid-template-columns:  auto 110px;
            grid-gap: 10px;
        }

        .line_grid2 span {
            display: flex;
            justify-content: space-between;
        }

        p {
            margin: 0;
        }

        .font_18 {
            font-size: 18px;
        }

        .mb-0 {
            margin-bottom: 0;
        }

        .mb_30 {
            margin-bottom: 30px !important;
        }

        .border_table {
        }

        .border_table thead tr th {
            padding: 5px;
        }

        .border_table tbody tr td {
            border: 1px solid #101010 !important;
            text-align: center;
            padding: 5px;
        }

        td, th {
            color: #101010;
            font-weight: 500;
            padding: 5px;

        }

        table {
            width: 100%;
        }

        @page {
            footer: page-footer;
        }
    </style>
</head>
<body>
<div class="invoice_wrapper">
    @php
        $p_total = 0;
        $p_qty = 0;
        $sub_total = 0;
        $others = 0;
        $total = 0;
        $qty = 0;
        $all_product = \Modules\Store\Entities\OrderPackageDetail::with('course')->where('order_id', $order->order_id)->get();
    @endphp
    <div class="invoice_print mb_30">
        <div class="container">
            <div class="invoice_part_iner">
                <table class="table border_bottom mb_30">
                    <thead>
                    <tr>
                        <td>
                            <div class="logo_div">
                                <img src="{{ getCourseImage(Settings('logo')) }}" alt="">
                            </div>
                        </td>
                        <td class="virtical_middle text_right invoice_info">
                            <h4 class="text_uppercase">{{ Settings('site_title') }}</h4>
                            <h4>{{ Settings('phone') }}</h4>
                            <h4>{{ Settings('email') }}</h4>
                            <h4>{{ $order->order->order_number }}</h4>
                        </td>
                    </tr>
                    </thead>
                </table>
                <table class="table">
                    <tbody>
                    <tr>
                        <td style="width: 50%">
                            <table class="mb_30">
                                <tbody>
                                <tr>
                                    <td>
                                        <h5 class="font_18 mb-0">{{ __('product.billing_info') }}</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Name') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{@$order->order->user->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                            <span>
                                                <span>{{__('product.email')}}</span>
                                                <span>:</span>
                                            </span>
                                            {{ $order->order->user->email }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                            <span>
                                                <span>{{__('product.phone')}}</span>
                                                <span>:</span>
                                            </span>
                                            {{@$order->order->user->phone}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                            <span>
                                                <span>{{__('product.addresses')}}</span>
                                                <span>:</span>
                                            </span>
                                            {{@$order->order->user->address}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                            <span>
                                                <span>{{__('product.city')}}</span>
                                                <span>:</span>
                                            </span>
                                            {{@$order->order->user->cityDetails->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                            <span>
                                                <span>{{__('product.state')}}</span>
                                                <span>:</span>
                                            </span>
                                            {{@$order->order->user->stateDetails->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                            <span>
                                                <span>{{__('product.Country')}}</span>
                                                <span>:</span>
                                            </span>
                                            {{@$order->order->user->userCountry->name}}
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 50%">
                            <table class="mb_30">
                                <tbody>
                                <tr>
                                    <td>
                                        <h5 class="font_18 mb-0">{{ __('product.company_info') }}</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                         <span>
                                                             <span>{{ __('product.name') }}</span>
                                                             <span>:</span>
                                                         </span>
                                            {{Settings('site_title')}}
                                        </p>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                         <span>
                                                             <span>{{ __('product.email') }}</span>
                                                             <span>:</span>
                                                         </span>
                                            {{Settings('email')}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                         <span>
                                                             <span>{{ __('product.phone') }}</span>
                                                             <span>:</span>
                                                         </span>
                                            {{Settings('phone')}}
                                        </p>
                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 50%">
                            <table>
                                <tbody>
                                <tr>
                                    <td>
                                        <h5 class="font_18 mb-0">{{ __('product.shipping_info') }}</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.name') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.email') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->email}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.phone') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->phone}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.address') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->address}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.city') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->city->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.state') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->state->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('product.Country') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{$order->pickupPoint->country->name}}
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <!--/ single table  -->
                        </td>
                        <td style="width: 50%">
                            <table>
                                <tbody>
                                <tr>
                                    <td>
                                        <!-- single table  -->
                                        <table class="mb_30">
                                            <tbody>
                                            <tr>
                                                <td>
                                                    <h5 class="font_18 mb-0">{{ __('product.order_info') }}</h5>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.is_paid') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{$order->order->is_paid == 1 ? 'Yes' : 'No'}}
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.subtotal') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        @php
                                                            $shipping_cost = 0;
                                                            $tax_amt = 0;
                                                        @endphp
                                                        @foreach ($all_product as $key => $item)
                                                            @php
//                                                                $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
//                                                                if ($item->is_store == 1) {
//                                                                    $price1 = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
//                                                                    $price = $price1 * $item->number_of_product;
//                                                                } else {
//                                                                    $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
//                                                                    $price1 = $price;
//                                                                }
              $enroll =\Modules\CourseSetting\Entities\CourseEnrolled::where('tracking',$item->order->tracking)->where('course_id',$item->course_id)->first();

                        if ($enroll){
                            $price =$enroll->purchase_price * $enroll->qty;
                            $price1 = $enroll->purchase_price;
                        }

                                                                $total = $total + $price;
                                                                $qty = $qty+($item->number_of_product*$item->tax_amount);
                                                                $shipping_cost = $shipping_cost + $item->shipping_cost;
                                                                $tax_amt = $tax_amt + $item->tax_amount;
                                                            @endphp
                                                        @endforeach

                                                        @php
                                                            $p_total = $p_total + $total;
                                                            if (isModuleActive('Tax')) {
                                                                $p_qty = $p_qty + $qty;
                                                            }
                                                        @endphp
                                                        {{  getPriceFormat($p_total) }}
                                                    </p>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.shipping_charge') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{getPriceFormat($shipping_cost)}}
                                                    </p>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.Tax') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{getPriceFormat($tax_amt)}}
                                                    </p>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.grand_total') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{ getPriceFormat($p_total + $tax_amt + $shipping_cost) }}
                                                    </p>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <!--/ single table  -->
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <table class="table">
        <tbody>
        <tr>
            <td style="width: 50%">
                <p class="line_grid_2">
                                <span>
                                    <span>{{ __('product.package') }}</span>
                                    <span>:</span>
                                </span>
                    {{ $order->package_code }}
                </p>
            </td>

            <td style="width: 50%">
                <p class="line_grid_auto grid_end">
                            <span>
                                <span>{{ __('product.shop_name') }}</span>
                                <span>:</span>
                            </span>
                    @if(@$order->seller->role->type == 'seller')
                        {{ (@$order->seller->SellerAccount->seller_shop_display_name) ? @$order->seller->SellerAccount->seller_shop_display_name : @$order->seller->first_name }}
                    @else
                        {{ Settings('site_title') }}
                    @endif
                </p>
            </td>
        </tr>
        <tr>
            <td style="width: 50%">
                @if (file_exists(base_path().'/Modules/GST/') && (app('gst_config')['enable_gst'] == "gst" || app('gst_config')['enable_gst'] == "flat_tax"))
                    @foreach ($order->gst_taxes as $key => $gst_tax)
                        <p class="line_grid_2 ">
                                        <span>
                                            <span>{{ $gst_tax->gst->name }}</span>
                                            <span>:</span>
                                        </span>
                            {{ single_price($gst_tax->amount) }}
                        </p>
                    @endforeach
                @endif
            </td>
            <td style="width: 50%">
                <p class="line_grid_auto grid_end">
                                <span>
                                    <span>{{ __('product.shipping_method') }}</span>
                                    <span>:</span>
                                </span>
                    {{ $order->shipping->method_name }}
                </p>
            </td>
        </tr>
        </tbody>
    </table>
    <h3 class="center title_text">{{ __('product.ordered_products')}}</h3>
    <table class="table border_table mb_30">
        <thead>
        <tr>
            <th>{{ __('product.name') }}</th>
            <th>{{ __('product.details') }}</th>
            <th>{{ __('product.price') }}</th>
            <th>{{ __('product.total') }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach ($all_product as $key => $item)
            <tr>
                <td class="text-start">{{$item->course->title}}</td>
                <td>{{$item->number_of_product}}</td>
                @php
//                    $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
//                    if ($item->is_store == 1) {
//                        $price1 = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
//                        $price = $price1 * $item->number_of_product;
//                    } else {
//                        $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
//                        $price1 = $price;
//                    }
              $enroll =\Modules\CourseSetting\Entities\CourseEnrolled::where('tracking',$item->order->tracking)->where('course_id',$item->course_id)->first();

                        if ($enroll){
                            $price =$enroll->purchase_price * $enroll->qty;
                            $price1 = $enroll->purchase_price;
                        }

                    $total = $total + $price;
                    $qty = $qty+($item->number_of_product*$item->tax_amount);
                @endphp

                <td class="text_right">
                    {{ getPriceFormat($price1) }}
                </td>
                <td class="text_right">
                    {{ getPriceFormat($price) }}
                </td>
            </tr>
        @endforeach
        </tbody>


    </table>
</div>

<script src="{{ asset('public/js/common.js') }}"></script>
<script type="text/javascript">
    (function ($) {
        "use strict";
        $(document).ready(function () {
            window.print();
        });
    })(jQuery);
</script>

</body>
</html>
