<?php

namespace Modules\Store\Imports;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Modules\CourseSetting\Entities\Course;
use Modules\Store\Entities\Product;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Modules\Store\Entities\ProductAuthor;
use Modules\Store\Entities\ProductBrand;
use Modules\Store\Entities\ProductCategory;

class ProductImport implements ToCollection, WithHeadingRow, WithMultipleSheets
{
    public function sheets(): array
    {
        return [
            '0' => new ProductImport(),
        ];
    }

    public function collection(Collection $rows)
    {
        $user = Auth::user();
        $rows = $rows->toArray();
        if (!isset($rows[0]['product_name']) || !isset($rows[0]['product_type'])) {
            Toastr::error(trans('org.Invalid Input'), trans('common.Failed'));
            return back()->send();
        }

        foreach ($rows as $row) {
             if (!empty($row['product_name']) && !empty($row['product_type'])) {
                $category = ProductCategory::select('id')->whereLike('title', $row['category'] ?? '')->pluck('id')->first();
                $brand = ProductBrand::select('id')->whereLike('name', $row['brand'] ?? '')->pluck('id')->first();
                $author = ProductAuthor::select('id')->whereLike('title', $row['author'] ?? '')->pluck('id')->first();
                $product = Product::create([
                    'title' => $row['product_name'],
                    'type' => $row['product_type']=='Virtual'?'1':'2',
                    'category_id' => $category ?? 0,
                    'brand_id' => $brand ?? 0,
                    'description' => $row['description'],
                    'delivery_fee' => $row['delivery_fee'],
                    'author_id' => $author ?? 0,
                    'inventory' => $row['inventory'],
                    'price' => $row['price'],
                    'is_readable' => $row['readable'] == 'Yes' ? 1 : 0,
                    'user_id' => Auth::id()

                ]);


                $product_course = new Course();
                $product_course->setTranslation('title', $user->language_code, $product->title);

                $product_course->setTranslation('about', $user->language_code, $product->description);

                $product_course->category_id = $product->category_id;
                $product_course->status = 1;
                $product_course->type = 5;
                $product_course->price = $product->price;
                $product_course->lang_id = $user->language_id;;


                $product_course->user_id = $user->id;
                $product_course->product_id = $product->id;
                $product_course->save();
            }
        }
    }
}
