<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Routing\Controller;
use Modules\Store\Http\Requests\CancelResonRequest;
use Modules\Store\Services\CancelReasonService;

class CancelReasonController extends Controller
{
    protected $cancelReasonService;

    public function __construct(CancelReasonService $cancelReasonService)
    {
        $this->cancelReasonService = $cancelReasonService;
    }

    public function index()
    {
        $data['items'] = $this->cancelReasonService->getAll();
        return view('store::order.cancel_reasons.index', $data);
    }

    public function process_list()
    {
        $data['items'] = $this->cancelReasonService->getAll();
        return view('store::order.cancel_reasons.reason_list', $data);
    }

    public function store(CancelResonRequest $request)
    {
        try {
            $this->cancelReasonService->save($request->except("_token"));
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.cancelreason.index');
        } catch (\Exception $e) {
            return response()->json(["message" => "Something Went Wrong", "error" => $e->getMessage()], 503);
        }
    }

    public function update(CancelResonRequest $request, $id)
    {
        try {
            $this->cancelReasonService->update($request->except("_token"), $id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.cancelreason.index');
        } catch (\Exception $e) {
            return response()->json(["message" => "Something Went Wrong", "error" => $e->getMessage()], 503);
        }
    }

    public function destroy($id)
    {
        try {
            $this->cancelReasonService->delete($id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return back();
        }
    }

    public function edit($id)
    {
        try {
            $data['items'] = $this->cancelReasonService->getAll();
            $data['edit'] = $this->cancelReasonService->getById($id);
            return view('store::order.cancel_reasons.index', $data);
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return back();
        }
    }
}
