<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;

class ShippingMethod extends Model
{
    protected $fillable = [];
    protected $guarded = ['id'];

    public function request_user()
    {
        return $this->belongsTo(User::class, 'request_by_user', 'id')->withDefault();
    }

    public function methodUse()
    {
        return $this->hasMany(ProductShipping::class, 'shipping_method_id', 'id');
    }

    public function carrier()
    {
        return $this->belongsTo(ProductCarrier::class, 'carrier_id', 'id')->withDefault();
    }
}
