<?php
namespace Modules\RegistrationBonus\Repositories;

use Modules\RegistrationBonus\Entities\RegistrationBonusHistory;

class RegistrationbonusRepositroy
{
    public $setting;

    public function __construct()
    {
        $this->setting = registrationBonusSetting();
    }

    public function isActive()
    {
        return $this->setting->is_active;
    }

    public function instantBonusEnable()
    {
        return $this->setting->instant_bonus;
    }

    public function referralBonusEnable()
    {
        return $this->setting->bonus_on_referrer;
    }

    public function PurchaseBonusEnable()
    {
        return $this->setting->bonus_on_purchase;
    }

    public function referralUsers()
    {
        return $this->setting->referrer_users;
    }

    public function referralPurchaseAmount()
    {
        return $this->setting->referrer_amount;
    }

    public function bonusAmount()
    {
        return $this->setting->bonus_amount;
    }

    public function instantBonus($user):void
    {
         if(!empty($user)){
            if($this->isActive() == 1 && $this->instantBonusEnable() == 1)
            {
                $old_balance = $user->balance;
                $new_balacne = $old_balance + $this->bonusAmount();
                $user->balance = $new_balacne;
                $user->save();

                $history = [
                    "user_id" => $user->id,
                    "amount"  => $this->bonusAmount(),
                    "bonus_for" => "new_registration",
                ];
                $this->createHistory($history);
            }
        }
    }

    public function referralBonus($user):void
    {
        if($user != null)
        {
            if($this->isActive() == 1 && $this->referralBonusEnable() == 1)
            {
                if($user->total_referrer_users == $this->referralUsers()){
                    $old_balance = $user->balance;
                    $new_balacne = $old_balance + $this->bonusAmount();
                    $user->balance = $new_balacne;
                    $user->total_referrer_users = 0;
                    $user->save();
                    $history = [
                        "user_id" => $user->id,
                        "amount"  => $this->bonusAmount(),
                        "bonus_for" => "referr_users",
                    ];
                    $this->createHistory($history);
                }
            }
        }
    }

    public function bonusOnPurchase($user)
    {
        if($user != null){
            if($this->isActive() == 1 && $this->PurchaseBonusEnable() == 1){
                if($this->referralPurchaseAmount() < $user->total_referrer_amount || $user->total_referrer_amount == $this->referralPurchaseAmount())
                {

                    $old_balance = $user->balance;
                    $new_balacne = $old_balance + $this->bonusAmount();
                    $user->balance = $new_balacne;
                    $user->total_referrer_amount = $user->total_referrer_amount - $this->bonusAmount();
                    $user->save();
                    $history = [
                        "user_id" => $user->id,
                        "amount"  => $this->bonusAmount(),
                        "bonus_for" => "course_purchase",
                    ];
                    $this->createHistory($history);
                }
            }
        }
    }

    public function createHistory($data)
    {
       return RegistrationBonusHistory::create($data);
    }

}
