@extends('backend.master')
@section('mainContent')
    {{ generateBreadcrumb() }}
    <section class="admin-visitor-area up_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row row-gap-4 justify-content-center">
                <div class="col-lg-12">
                    <h3>
                        {{$data['top_title']}}
                    </h3>
                </div>
                <div class="col-md-6 col-lg-3">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>{{_trans('installment.Pending Verification')}} </h3>
                                </div>
                                <h1 class="gradient-color2"
                                    id="totalStudent">{{@$data['user_installment_overview']['pending_verification']}}</h1>
                            </div>
                        </div>
                    </a>
                </div>


                <div class="col-md-6 col-lg-3">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>{{_trans('installment.Open Installment')}} </h3>
                                </div>
                                <h1 class="gradient-color2"
                                    id="totalInstructor">{{@$data['user_installment_overview']['open']}}</h1>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-6 col-lg-3">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>
                                        {{_trans('installment.Finished')}}
                                    </h3>
                                </div>
                                <h1 class="gradient-color2"
                                    id="totalCourses">{{@$data['user_installment_overview']['complete']}}</h1>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-md-6 col-lg-3">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>{{_trans('installment.Overdue')}} </h3>
                                </div>
                                <h1 class="gradient-color2"
                                    id="totalEnroll">{{@$data['user_installment_overview']['overdue']}}</h1>
                            </div>
                        </div>
                    </a>
                </div>

            </div>
            <div class="row row-gap-24 mt-20">
                <div class="col-lg-12">
                    <h4>
                        {{$data['title']}}
                    </h4>
                    <div class="white-box">
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <table id=" " class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th>{{_trans('common.SL')}} </th>
                                        <th>{{_trans('installment.Title')}} </th>
                                        <th>{{_trans('installment.Amount')}} </th>
                                        <th>{{_trans('installment.Due Date')}} </th>
                                        <th>{{_trans('installment.Payment Date')}} </th>
                                        <th>{{_trans('installment.Payment Status')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($data['purchase']->installmentPayments as $key =>  $installment_payment)
                                        <tr>
                                            <td>{{translatedNumber(++$key)}}</td>
                                            <td>
                                                {{isset($installment_payment->step) ? @$installment_payment->step->payment_title : ($key==0 ? 'Upfront' : 'Installment')}}
                                            </td>
                                            <td>
                                                {{ getPriceFormat(@$installment_payment->amount) }}
                                            </td>
                                            <td>
                                                {{showDate(@$installment_payment->due_date)}}

                                            </td>
                                            <td>
                                                {{showDate(@$installment_payment->payment_date)}}

                                            </td>


                                            <td>
                                                {{ Str::ucfirst(@$installment_payment->status) }}
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="col-lg-12">

                    <div class="white-box">

                        <h4>
                            {{_trans('installment.Verification Document')}}
                        </h4>

                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">

                                <table id=" " class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th>{{__('common.SL')}}</th>
                                        <th>
                                            {{_trans('installment.Title')}}
                                        </th>
                                        <th>
                                            {{_trans('installment.File')}}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse ($data['purchase']->installmentAttachment as $key => $attachmane)
                                        <tr>
                                            <td>{{translatedNumber(++$key)}}</td>
                                            <td>
                                                <p> {{@$attachmane->title}}</p>
                                            </td>
                                            <td>
                                                <a href="{{asset($attachmane->file)}}" target="_blank" download
                                                   class="primary-btn small w-fit fix-gr-bg text-white"><i
                                                        class="fa fa-download"></i></a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="3">
                                                <p class="text-center">{{_trans('installment.No Document Found')}} </p>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
            @if($data['purchase']->payment_status != 'complete')
                <div class="row mt-40">
                    <div class="col-lg-12 text-center d-flex justify-content-center">
                        @if($data['purchase']->payment_status=='approved')
                            <a href="#" data-bs-toggle="modal" data-bs-target="#reject_modal"
                               data-request_id="{{@$data['purchase']->id}}"
                               class="primary-btn fix-gr-bg reject_request w-fit"><i class="fa fa-ban"
                                                                                     aria-hidden="true"></i>{{ _trans('installment.Cancel') }}
                            </a>
                        @else
                            <a href="#" data-bs-toggle="modal" data-bs-target="#reject_modal"
                               data-request_id="{{@$data['purchase']->id}}"
                               class="primary-btn fix-gr-bg reject_request  w-fit"><i class="fa fa-ban"
                                                                                      aria-hidden="true"></i> {{ _trans('installment.Reject') }}
                            </a>
                            <a href="#" data-bs-toggle="modal" data-bs-target="#approve_modal"
                               data-request_id="{{@$data['purchase']->id}}"
                               class="primary-btn fix-gr-bg approve_request ms-3 w-fit"><i
                                    class="ti-check"></i> {{ _trans('installment.Approve') }}</a>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </section>

    <div class="modal fade admin-query" id="approve_modal">
        <div class="modal-dialog modal-dialog-centered modal_650px">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">{{ _trans('installment.Approve Confirmation') }} </h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                            class="ti-close "></i></button>
                </div>

                <div class="modal-body">
                    <h2 class="text-center">
                        {{_trans('installment.Are you sure to approve this request?')}}
                    </h2>

                    <form action="{{ route('installment.purchase.change_status') }}" method="POST">
                        @csrf
                        <input type="hidden" name="purchase_id" value="">
                        <input type="hidden" name="status" value="approved">
                        <div class="mt-40 d-flex justify-content-between">
                            <button type="button" class="primary-btn tr-bg"
                                    data-bs-dismiss="modal">{{__('common.Cancel')}}</button>

                            <button class="primary-btn fix-gr-bg">{{_trans('installment.Approve')}}</button>

                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
    <div class="modal fade admin-query" id="reject_modal">
        <div class="modal-dialog modal-dialog-centered modal_650px">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">{{ _trans('installment.Reject Confirmation') }} </h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                            class="ti-close "></i></button>
                </div>

                <div class="modal-body">
                    <p class="text-center">
                        {{_trans('installment.Installment Request will be removed')}}
                    </p>
                    <p class="text-center">
                        {{_trans('installment.and refund Upfront amount to student')}}
                    </p>
                    {{-- <form action="{{route('admin.enrollDelete')}}" method="POST"> --}}
                    <form action="{{ route('installment.purchase.reject_request') }}" method="POST">
                        @csrf
                        <input type="hidden" name="request_id" value="">
                        <div class="mt-40 d-flex justify-content-between">
                            <button type="button" class="primary-btn tr-bg"
                                    data-bs-dismiss="modal">{{__('common.Cancel')}}</button>

                            <button class="primary-btn fix-gr-bg">{{__('common.Refund')}}</button>

                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $('.reject_request').on('click', function () {
                var request_id = $(this).data('request_id');
                $('input[name="request_id"]').val(request_id);
            });
            $('.approve_request').on('click', function () {
                var request_id = $(this).data('request_id');
                $('input[name="purchase_id"]').val(request_id);
            });
        })(jQuery);

    </script>
@endpush
