<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\SystemSetting\Entities\EmailTemplate;

class GiftEmailTemplate extends Migration
{
    public function up()
    {
        $template = EmailTemplate::where('act', 'SEND_GIFT')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'SEND_GIFT';
        }
        $shortCode = '{"name":"Gift Receiver Name","course":"Course Name","sender":"Gift Sender Name","message":"Sender Message","link":"Course Link"}';

        $subject = 'You Have A Gift';


        $br = "<br/>";
        $body = " Hello, {{name}} " . $br . "You have a gift: {{course}} " . $br . "Gift sender: {{sender}} " . $br . "Message: {{message}} " . $br . "Click Here to see detail: {{course_link}}," . "{{footer}}";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();

        DB::table('role_email_templates')
            ->where('template_act', 'SEND_GIFT')
            ->where('role_id', 3,)
            ->updateOrInsert([
                'template_act' => 'SEND_GIFT',
                'role_id' => 3,
                'status' => 1,
            ]);

        DB::table('role_email_templates')
            ->where('template_act', 'SEND_GIFT')
            ->where('role_id', 2,)
            ->updateOrInsert([
                'template_act' => 'SEND_GIFT',
                'role_id' => 2,
                'status' => 1,
            ]);
    }


    public function down()
    {
        //
    }
}
