<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Modules\FrontendManage\Entities\FrontPage;
use Modules\FrontendManage\Entities\HeaderMenu;

class AddBundleStaticPageToFrotpage extends Migration
{
    public function up()
    {
        Schema::table('front_pages', function (Blueprint $table) {
            $frontPage = FrontPage::where('slug', '/bundle-subscription/1')->first();
            if (empty($frontPage)) {
                $frontPage = FrontPage::where('slug', '/bundle-subscription/courses')->first();
            }
            if (!$frontPage) {
                $frontPage = new FrontPage();
            }

            $frontPage->name = 'Bundle Subscription';
            $frontPage->title = 'Bundle Subscription';
            $frontPage->sub_title = 'Bundle Subscription';
            $frontPage->details = 'Bundle Subscription';
            $frontPage->slug = '/bundle-subscription/courses';
            $frontPage->status = 1;
            $frontPage->is_static = 1;
            $frontPage->save();


            $header_menu = HeaderMenu::where('link', '/bundle-subscription/courses')->first();
            if ($header_menu == null) {
                $menu = new HeaderMenu();
                $menu->type = "Static Page";
                $menu->element_id = $frontPage->id;
                $menu->title = $frontPage->title;
                $menu->link = $frontPage->slug;
                $menu->position = 8;
                $menu->save();

            }
        });
    }

    public function down()
    {

    }
}
