<div class="tab-pane fade @if (Session::has('schedule')) show active @endif " id="Course" role="tabpanel"
     aria-labelledby="General-tab">
    <div class="white_box_30px">
        <div class="main-title mb-25">
            <h3 class="mb-0">{{ __('setting.Specific Course Commission Setup') }} </h3>
        </div>

        <form
            action="    @if (permissionCheck('setting.courseCommission_update')) {{ route('courseCommission') }} @endif"
            method="post">

            @csrf
            <div class="row">
                <div class="col-xl-6">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label" for="">{{ __('courses.Select Course') }}</label>
                        <select name="course" class="primary_select mb-25" required>
                            <option value="">{{ __('courses.Select Course') }}</option>
                            @foreach ($allcourses as $course)
                                <option value="{{ @$course->id }}"
                                        @if (Session::has('course_id')) @if (Session::get('course_id') == $course->id)
                                            selected @endif
                                    @endif
                                > {{ @$course->title }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-xl-6">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label"
                               for="">{{ __('setting.Instructor Revenue percentage of course fee') }} </label>
                        <input class="primary_input_field"
                               value="@if (Session::has('amount')) {{ Session::get('amount') }} @endif"
                               name="course_commission" id="instructor_comm"
                               placeholder="{{ __('setting.Instructor Commission') }}(%)" type="number" min="0"
                               required>
                    </div>
                </div>


                @php
                    $tooltip = '';
                    if (!permissionCheck('setting.courseCommission_update')) {

                        $tooltip = 'You have no permission to Update';
                    }
                @endphp

                <div class="col-12 mb-10 pt_15">
                    <div class="submit_btn text-center">
                        <button class="primary-btn fix-gr-bg" type="submit"><i class="ti-check"></i>
                            {{ __('common.Update') }} {{ __('setting.Setting') }}
                        </button>
                    </div>
                </div>
            </div>
        </form>

    </div>
    <div class="col-lg-12 mt-60 p-0">
        <div class="box_header">
            <div class="main-title d-flex flex-wrap mb-0">
                <h3 class="mb-0">{{ __('setting.Specific Course List') }}</h3>
            </div>
        </div>

        <div class="QA_section QA_section_heading_custom check_box_table">
            <div class="QA_table ">
                <!-- table-responsive -->
                <div class="">
                    <table id="lms_table" class="table Crm_table_active3">
                        <thead>
                        <tr>

                            <th scope="col"> {{ __('common.SL') }} </th>
                            <th scope="col"> {{ __('common.Image') }} </th>
                            <th scope="col"> {{ __('courses.Course Title') }} </th>
                            <th scope="col"> {{ __('courses.Created') }} </th>
                            <th scope="col"> {{ __('courses.Instructor Revenue') }} </th>
                            <th scope="col"> {{ __('courses.Admin Revenue') }} </th>
                            <th scope="col"> {{ __('courses.Enrolls') }} </th>
                            <th scope="col"> {{ __('common.Action') }} </th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($courses as $key => $course)
                            @php
                                $admin_commission = 100 - $course->special_commission;
                            @endphp
                            <tr>
                                <th>{{ $key + 1 }}</th>

                                <td class="nowrap">
                                    <div class="profile_info">
                                        <img src="{{ asset(@$course->user->image) }}">
                                    </div>
                                </td>
                                <td class="nowrap">{{ @$course->title }}</td>
                                <td class="nowrap">{{ @$course->user->name }}</td>
                                <td class="nowrap">{{ @$course->special_commission }}</td>
                                <td class="nowrap">{{ @$admin_commission }}</td>
                                <td class="nowrap">{{ @$course->enrollCount }}</td>
                                <td class="nowrap">


                                    <div class="dropdown CRM_dropdown">
                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                id="dropdownMenu2" data-bs-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                            {{ __('common.Action') }}
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right"
                                             aria-labelledby="dropdownMenu2">
                                            @if (permissionCheck('setting.courseCommission_edit'))
                                                <a href="#" data-bs-toggle="modal"
                                                   data-bs-target="#editInstractor{{ @$course->id }}"
                                                   class="dropdown-item"
                                                   type="button">{{ __('common.Edit') }}</a>
                                            @endif

                                        </div>
                                    </div>
                                </td>

                            </tr>


                            <div class="modal fade admin-query" id="editInstractor{{ @$course->id }}">
                                <div class="modal-dialog modal_800px modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title">{{ @$course->title }}</h4>
                                            <button type="button" class="close " data-bs-dismiss="modal">
                                                <i class="ti-close "></i>
                                            </button>
                                        </div>

                                        <div class="modal-body">
                                            <form action="{{ route('courseCommission') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="course" value="{{ @$course->id }}">
                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="">{{ __('courses.Instructor Commission Percentage') }}</label>
                                                            <div class="tagInput_field">
                                                                <input class="primary_input_field"
                                                                       name="course_commission" type="text"
                                                                       value="{{ @(int) $course->special_commission }}">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-12 text-center pt_15">
                                                        <div class="d-flex justify-content-center">
                                                            <button class="primary-btn semi_large2  fix-gr-bg"
                                                                    type="submit"><i
                                                                    class="ti-check"></i>{{ __('common.Update') }}
                                                                {{ __('setting.Settings') }}
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
