@extends('appointment::layouts.master')
@php
    $table_name = 'time_slots';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    <input type="hidden" id="row_count" value="1">
    <section class="sms-breadcrumb mb-10 white-box">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1>{{ __('appointment.Booked User List') }}</h1>
                <div class="bc-pages">
                    <a href="{{ route('dashboard') }}">{{ __('common.Dashboard') }}</a>
                    <a href="#">{{ __('appointment.appointment') }}</a>
                    <a class="active"
                       href="{{ route('appointment.time-slot.index') }}">{{ __('appointment.Booked User List') }}</a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header">
                            <h4>{{__('appointment.Filter Booking History')}}</h4>
                        </div>
                        @php
                            $div = auth()->user()->role_id == 1 ? 'col-xl-3 col-md-3 col-lg-3' : 'col-xl-4 col-md-4 col-lg-4'
                        @endphp

                        <form method="POST" action="{{ route('appointment.booking.user.search') }}">
                            @csrf
                            <div class="row">

                                <div class="{{ $div }}">

                                    <label class="primary_input_label"
                                           for="instructor">{{__('appointment.Time Slot')}}</label>
                                    <select class="primary_select" name="time_slot" id="instructor">
                                        <option data-display="{{__('common.Select')}} {{__('appointment.Time Slot')}}"
                                                value="">{{__('common.Select')}} {{__('appointment.Time Slot')}}</option>
                                        @foreach($timeSlots as $slot)
                                            <option
                                                value="{{$slot->id}}" {{isset($payload) ? ($payload['time_slot'] == $slot->id ? 'selected' : '') : ''}}>
                                                {{  date('h:i A', strtotime(@$slot->start_time))  }} -
                                                {{date('h:i A', strtotime(@$slot->end_time))  }} </option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="{{ $div }}">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="startDate">{{__('common.Select')}} {{__('common.Start Date')}}</label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="startDate" type="text" name="start_date"
                                                               value="{{isset($payload)?!empty($payload['start_date'])?date('m/d/Y', strtotime($payload['start_date'])):'':''}}"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="start-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="{{ $div }}">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="admissionDate">{{__('common.Select')}} {{__('common.End Date')}}</label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="admissionDate" type="text" name="end_date"
                                                               value="{{isset($payload)?!empty($payload['end_date'])?date('m/d/Y', strtotime($payload['end_date'])):'':''}}"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="admission-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if(auth()->user()->role_id==1)
                                    <div class="{{ $div }}">

                                        <label class="primary_input_label"
                                               for="instructor">{{__('courses.Instructor')}}</label>
                                        <select class="primary_select" name="instructor" id="instructor">
                                            <option data-display="{{__('common.Select')}} {{__('courses.Instructor')}}"
                                                    value="">{{__('common.Select')}} {{__('courses.Instructor')}}</option>
                                            @foreach($instructors as $data)
                                                <option
                                                    value="{{$data->id}}" {{ isset($payload) ? ($payload['instructor'] == $data->id?'selected':'') :''}}>{{@$data->name}} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                @endif
                                <div class="col-md-12 col-xl-12 mt-30">
                                    <div class="search_course_btn text-end">
                                        <button type="submit"
                                                class="primary-btn radius_30px   fix-gr-bg">{{__('common.Filter History')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                @isset($bookedUsers)
                    <div class="col-lg-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0">{{ __('appointment.Booked User List') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Student Name') }}</th>
                                            <th scope="col">{{ __('common.Date') }}</th>

                                            <th scope="col">{{ __('common.Instructor') }}</th>
                                            <th scope="col">{{ __('appointment.Booked Time') }}</th>
                                            <th scope="col">{{ __('appointment.Share Link') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($bookedUsers as $key => $booking)
                                            <tr>
                                                <th class="m-2">{{ $loop->iteration }}</th>
                                                <td>{{ $booking->userInfo->name }}</td>
                                                <td>{{ showDate($booking->schedule->schedule_date) }}
                                                    <br>[{{ $booking->schedule ? date('h:i A', strtotime(@$booking->schedule->slotInfo->start_time)) :'' }}
                                                    - {{ $booking->schedule ? date('h:i A', strtotime(@$booking->schedule->slotInfo->end_time)) :'' }}
                                                    ]
                                                </td>

                                                <td>{{ $booking->schedule->userInfo->name }}</td>

                                                <td>{{ showDate($booking->created_at) }}</td>
                                                <td><a href="{{ $booking->share_link }}"
                                                       target="_blank">{{ __('appointment.Link') }}</a></td>


                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$booking->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$booking->id }}">
                                                            @if(permissionCheck('appointment.booking.shareLink'))
                                                                <a data-bs-toggle="modal" id="add_share_btn"
                                                                   data-bs-target="#add_shareLink"
                                                                   data-student_id="{{ $booking->user_id }}"
                                                                   data-schedule_id="{{ $booking->schedule_id }}"
                                                                   data-booking_id="{{ $booking->id }}"
                                                                   data-type="{{ $booking->type }}"
                                                                   data-share_link="{{ $booking->share_link }}"
                                                                   class="dropdown-item add_share_btn">{{ __('appointment.Share Link') }}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endisset
            </div>
        </div>
    </section>
    @include('appointment::booking._share_link_modal')
    @include('backend.partials.delete_modal')

@endsection
@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $(document).on('click', '.add_share_btn', function () {
                let schedule_id = $(this).data('schedule_id');
                let student_id = $(this).data('student_id');
                let booking_id = $(this).data('booking_id');
                let type = $(this).data('type');
                if (type == 'single') {
                    $("#single").prop("checked", true);
                } else {
                    $("#all").prop("checked", true);
                }
                let share_link = $(this).data('share_link');
                $('#schedule_id').val(schedule_id);
                $('#student_id').val(student_id);
                $('#booking_id').val(booking_id);
                $('#share_link').val(share_link);
            });
        })(jQuery);

    </script>
@endpush
