(function ($) {
    "use strict";

    $(document).ready(function () {
        $("#order,  .type, .level, .category, .price_range, .age_range, .days, .country").on('change keyup paste', function (e) {
            ApplyFilter();
        });
    });

    function ApplyFilter() {
        var order = $('#order').find(":selected").val();
        var country = $('#country').find(":selected").val();
        var price_range = $(".price_range").val();
        var age_range = $(".age_range").val();

        let url = $('.class_route').val();
        let search = $('.query').val();

        var type = [];
        $('.type:checked').each(function (i) {
            type[i] = $(this).val();
        });
        url += '/?type=' + type.toString();

        var days = [];
        $('.days:checked').each(function (i) {
            days[i] = $(this).val();
        });
        url += '&days=' + days.toString();


        var level = [];
        $('.level:checked').each(function (i) {
            level[i] = $(this).val();
        });
        url += '&level=' + level.toString();


        var category = [];
        $('.category:checked').each(function (i) {
            category[i] = $(this).val();
        });
        url += '&category=' + category.toString();
        url += '&order=' + order.toString();
        url += '&price_range=' + price_range.toString();
        url += '&age_range=' + age_range.toString();
        url += '&country=' + country.toString();


        window.location.href = url;

    }
})(jQuery);
