<?php

namespace Modules\Appointment\Entities;

use App\Traits\Tenantable;
use App\User;
use DateTime;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class TimeSlot extends Model
{
    use Tenantable;

    protected $fillable = ['start_time', 'end_time', 'created_by', 'user_id', 'updated_by'];

    public function instructor()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->withDefault();
    }
    public function getDurationAttribute()
    {

        $start_time = Carbon::parse($this->start_time);
        $end_time = Carbon::parse($this->end_time);

        $timeInMin = $end_time->diffInMinutes($start_time);
        $hours = intval($timeInMin/60);
        $minutes = $timeInMin%60;

        if ($minutes > 0 && $hours > 0) {
            $duration =  $hours." Hours ".$minutes." Minutes";
        } elseif ($minutes > 0 && $hours == 0) {
            $duration = $minutes." Minutes";
        } else {
            $duration = $hours." Hours ";
        }
        return  $duration;
    }
    public function getStartToEndAttribute()
    {

        $start_time = Carbon::parse($this->start_time);
        $end_time = Carbon::parse($this->end_time);

        return  $startToEnd = $start_time .'-'. $end_time;
    }
}
