<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBookTrailLessonsTable extends Migration
{
    public function up()
    {
        Schema::create('book_trail_lessons', function (Blueprint $table) {
            $table->id();
            $table->integer('instructor_id')->nullable();
            $table->integer('student_id')->nullable();
            $table->text('share_link')->nullable();
            $table->integer('schedule_id')->nullable();
            $table->tinyInteger('status')->nullable()->default(1);
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('book_trail_lessons');
    }
}
