<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShareLinksTable extends Migration
{
    public function up()
    {
        Schema::create('share_links', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('status')->nullable()->default(1);
            $table->text('link')->nullable();
            $table->text('note')->nullable();
            $table->integer('schedule_id')->nullable();
            $table->integer('student_id')->nullable();
            $table->integer('type')->nullable()->comment('0=single, 1=all');
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('share_links');
    }
}
