<?php

namespace Modules\UpcomingCourse\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;

class UpcomingCourseBooking extends Model
{
    protected $guarded = ["id"];

    public function course()
    {
        return $this->belongsTo(Course::class,'course_id')->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id')->withDefault();
    }

    public function payments()
    {
        return $this->hasMany(UpcomingCourseBookingPayment::class,'booking_id');
    }
}
