<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserOtpCodesTable extends Migration
{
    public function up()
    {
        Schema::create('user_otp_codes', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();
            $table->string('email')->nullable();
            $table->string('otp_code')->nullable();
            $table->string('expired_time')->nullable();
            $table->boolean('is_active')->default(TRUE);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_otp_codes');
    }
}
