<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSurveyQuestionBanksTable extends Migration
{
    public function up()
    {
        Schema::create('survey_question_banks', function (Blueprint $table) {
            $table->id();
            $table->string('type');
            $table->text('question')->nullable();
            $table->integer('number_of_option')->nullable();
            $table->integer('group_id')->nullable();
            $table->integer('category_id')->nullable();
            $table->integer('sub_category_id')->nullable();
            $table->string('image')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->integer('user_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('survey_question_banks');
    }
}
