<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Subscription\Entities\Faq;

class CreateFaqsTable extends Migration
{

    public function up()
    {
        Schema::create('faqs', function (Blueprint $table) {
            $table->id();
            $table->string('question')->nullable();
            $table->text('answer')->nullable();
            $table->integer('status')->default(1);
            $table->integer('order')->default(1);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });

        DB::table('faqs')->insert([
            [
                'question' => 'My views keep fluctuating or freezing. What can I do?',
                'answer' => "This can happen! View counts can slow down or even seem frozen as we verify they're real (from humans not computer programs). This is part of how our system works to make sure we’re counting views correctly.",
                'order' => 1,
            ],
            [
                'question' => 'My video upload is stuck in processing. What do I do?',
                'answer' => 'Your internet connection: Slow or unstable internet can make it tough to upload videos. Or, you may be trying to upload during peak hours. Tip: you can make a simple diagnostic by running a speed test and see if the internet connection is having issues wit',
                'order' => 2,
            ], [
                'question' => 'How do I get the Community tab??',
                'answer' => 'Good news, the Community tab is now available to all channels with over 1,000 subscribers! ',
                'order' => 3,
            ], [
                'question' => 'Issue with livestream',
                'answer' => 'If you’re having issues enabling live streaming on mobile, know that after reaching 1K subs, it may take several weeks before mobile live streaming is enabled. Also, if your sub count decreases at any point during this time',
                'order' => 4,
            ],
        ]);


    }


    public function down()
    {
        Schema::dropIfExists('faqs');
    }
}
