(function ($) {
    "use strict";
    let _token = $('meta[name=_token]').attr('content');
    $(document).ready(function () {

        $(document).on('click', '.carrier_status', function (event) {
            event.preventDefault();
            $('.preloader').removeClass('d-none');
            let id = $(this).data('id');
            let url = $('#carrier_status_url').val();
            url = url.replace(':id', id);
            $.get(url, function (response) {
                if (response) {
                    $('#append_html').html(response);
                    $('#carrier_status_modal').modal('show');
                    $('.preloader').addClass('d-none');
                }
            });
        });

        $(document).on('click', '.customer_address_edit', function (event) {
            event.preventDefault();
            $('.preloader').removeClass('d-none');
            let id = $(this).data('id');
            let url = $('#customer_address_edit').val();
            url = url.replace(':id', id);
            $.get(url, function (response) {
                if (response) {
                    $('#append_html').html(response);
                    $('#customer_address_edit_modal').modal('show');
                    $('.primary_select').niceSelect();
                    $('.preloader').addClass('d-none');
                }
            });
        });

        $(document).on('submit', '#address_form', function (event) {
            event.preventDefault();
            $('.preloader').removeClass('d-none');
            let formElement = $(this).serializeArray()
            let formData = new FormData();
            formElement.forEach(element => {
                formData.append(element.name, element.value);
            });
            formData.append('_token', _token);
            let url = $('#customer_address_update').val();
            resetValidationError();
            $.ajax({
                url: url,
                type: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: formData,
                success: function (response) {
                    $('#customer_address_edit_modal').modal('hide');
                    $('.preloader').addClass('d-none');
                    location.reload();
                    toastr.success('Shipping Address Updated Successfully');
                },
                error: function (response) {
                    $('.preloader').addClass('d-none');
                    showValidationErrors('#address_form', response.responseJSON.errors);
                }
            });
        });


        $(document).on('click', '.packaging_edit', function (event) {
            event.preventDefault();
            $('.preloader').removeClass('d-none');
            let id = $(this).data('id');
            let url = $('#packaging_edit_url').val();
            url = url.replace(':id', id);
            $.get(url, function (response) {
                if (response) {
                    $('#append_html').html(response);
                    $('#packaging_modal').modal('show');
                    $('.preloader').addClass('d-none');
                }
            });
        });

        $(document).on('submit', '#packaging_form', function (event) {
            event.preventDefault();
            $('.preloader').removeClass('d-none');
            let formElement = $(this).serializeArray()
            let formData = new FormData();
            formElement.forEach(element => {
                formData.append(element.name, element.value);
            });
            formData.append('_token', _token);
            let url = $('#packaging_update_url').val();
            resetValidationError();
            $.ajax({
                url: url,
                type: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: formData,
                success: function (response) {
                    $('#packaging_modal').modal('hide');
                    $('.preloader').addClass('d-none');
                    location.reload();
                    toastr.success('Packaging Info Updated Successfully');
                },
                error: function (response) {
                    $('.preloader').addClass('d-none');
                    showValidationErrors('#packaging_form', response.responseJSON.errors);
                }
            });
        });


        function showValidationErrors(formType, errors) {
            $(formType + ' #error_weight').text(errors.weight);
            $(formType + ' #error_length').text(errors.length);
            $(formType + ' #error_breadth').text(errors.breadth);
            $(formType + ' #error_height').text(errors.height);
            $(formType + ' #error_customer_shipping_name').text(errors.shipping_name);
            $(formType + ' #error_customer_shipping_email').text(errors.shipping_email);
            $(formType + ' #error_customer_shipping_phone').text(errors.shipping_phone);
            $(formType + ' #error_customer_shipping_address').text(errors.shipping_address);
            $(formType + ' #error_customer_shipping_post_code').text(errors.shipping_postcode);
            $(formType + ' #error_customer_shipping_country').text(errors.shipping_country);
            $(formType + ' #error_customer_shipping_state').text(errors.shipping_state);
            $(formType + ' #error_customer_shipping_city').text(errors.shipping_city);

            $(formType + ' #error_customer_billing_name').text(errors.billing_name);
            $(formType + ' #error_customer_billing_email').text(errors.billing_email);
            $(formType + ' #error_customer_billing_phone').text(errors.billing_phone);
            $(formType + ' #error_customer_billing_address').text(errors.billing_address);
            $(formType + ' #error_customer_billing_post_code').text(errors.billing_postcode);
            $(formType + ' #error_customer_billing_country').text(errors.billing_country);
            $(formType + ' #error_customer_billing_state').text(errors.billing_state);
            $(formType + ' #error_customer_billing_city').text(errors.billing_city);
        }

        function resetValidationError() {
            $('#error_weight').html('');
            $('#error_length').html('');
            $('#error_breadth').html('');
            $('#error_height').html('');
            $('#error_customer_shipping_name').html('');
            $('#error_customer_shipping_email').html('');
            $('#error_customer_shipping_phone').html('');
            $('#error_customer_shipping_address').html('');
            $('#error_customer_shipping_post_code').html('');
            $('#error_customer_shipping_country').html('');
            $('#error_customer_shipping_state').html('');
            $('#error_customer_shipping_city').html('');
            $('#error_customer_billing_name').html('');
            $('#error_customer_billing_email').html('');
            $('#error_customer_billing_phone').html('');
            $('#error_customer_billing_address').html('');
            $('#error_customer_billing_post_code').html('');
            $('#error_customer_billing_country').html('');
            $('#error_customer_billing_state').html('');
            $('#error_customer_billing_city').html('');
        }
    });
})(jQuery);
