<?php

namespace Modules\Chat\Entities;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Chat\Database\factories\GroupFactory;
use Ramsey\Uuid\Uuid;
use App\Traits\Tenantable;


class Group extends Model
{
    use Tenantable;

    public $incrementing = false;
    protected $table = 'chat_groups';
    protected $fillable = [
        'name', 'description', 'photo_url', 'group_type', 'privacy', 'created_by', 'read_only'
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function (Model $model) {
            $model->setAttribute($model->getKeyName(), Uuid::uuid4());
        });
    }


    public function users()
    {
        return $this->belongsToMany(User::class, 'chat_group_users', 'group_id', 'user_id')
            ->wherePivot('deleted_at', '=', null)
            ->withPivot(['deleted_at', 'created_at']);
    }

    public function threads()
    {
        return $this->hasMany(GroupMessageRecipient::class, 'group_id')->whereDoesntHave('removeMessages');
    }

    public function getPhotoUrlAttribute()
    {
        if (!empty($this->attributes['photo_url']) && file_exists(base_path($this->attributes['photo_url']))) {
            return asset($this->attributes['photo_url']);
        }
        return asset('public/chat/images/bw-spondon-icon.png');
    }
}
