<?php

namespace Modules\Cashback\Entities;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Cashback\Entities\CashbackRuleUser;
use Modules\Cashback\Entities\RuleSpecificItem;
use Modules\Cashback\Entities\UserCashbackDetail;

class CashbackRule extends Model
{
    use HasTranslations,SoftDeletes;

    public $translatable = ['title'];
    protected $fillable = [];

    public function rule_specific_item()
    {
        return $this->hasOne(RuleSpecificItem::class, 'rule_id');
    }

    public function userCashbackDetails()
    {
        return $this->hasMany(UserCashbackDetail::class, 'rule_id');
    }

    public function getStatusTextAttribute()
    {
        if ($this->status == 1) {
            return _trans('common.Active');
        } else {
            return _trans('common.Inactive');
        }
    }

    public function users(){
        return $this->hasMany(CashbackRuleUser::class);
    }

    public function totalUser(){
        $cashbacks=$this->userCashbackDetails->toArray();
        $user_ids=array_unique(array_column($cashbacks,'user_cashback_id'));
        return count($user_ids);


    }
}
