<?php

use Illuminate\Database\Migrations\Migration;

class AddBundleSubscriptionPermission extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => 'BundleSubscription', 'route' => 'bundle.subscription', 'type' => 1, 'parent_route' => null, 'module' => 'BundleSubscription'],
            ['name' => 'Bundle Course', 'route' => 'bundle.course', 'type' => 2, 'parent_route' => 'bundle.subscription', 'module' => 'BundleSubscription'],
            ['name' => 'Bundle Store', 'route' => 'bundle.store', 'type' => 3, 'parent_route' => 'bundle.course', 'module' => 'BundleSubscription'],
            ['name' => 'Bundle Edit', 'route' => 'bundle.update', 'type' => 3, 'bundle.course', 'parent_route' => 'bundle.course', 'module' => 'BundleSubscription'],

            ['name' => 'Bundle Course List', 'route' => 'bundle.course.index', 'type' => 3, 'parent_route' => 'bundle.course', 'module' => 'BundleSubscription'],
            ['name' => 'Bundle Course Store', 'route' => 'bundle.course.store', 'type' => 3, 'parent_route' => 'bundle.course', 'module' => 'BundleSubscription'],
            ['name' => 'Bundle Course Delete', 'route' => 'bundle.course.delete', 'type' => 3, 'parent_route' => 'bundle.course', 'module' => 'BundleSubscription'],

            ['name' => 'Bundle Setting', 'route' => 'bundle.setting.index', 'type' => 2, 'parent_route' => 'bundle.subscription', 'module' => 'BundleSubscription'],


        ];
        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {

    }
}
