<?php

namespace Modules\Appointment\Repositories\Interfaces;

use App\Repositories\Interfaces\EloquentRepositoryInterface;

interface BookingRepositoryInterface extends EloquentRepositoryInterface
{
    public function index(array $payload): array;

    public function store(array $payload);

    public function bookedUser(array $payload): array;

    public function shareLink(array $payload);

    public function bookTrailLesson($slug);

    public function trailLesson(array $payload);

    public function trailLessonDelete($id);

    public function approve($approve_id);

    public function reject($reject_id);

    public function editValue(array $payload): array;

    public function getListByUser($user_id);
}
