<?php

namespace Modules\Appointment\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Appointment\Entities\BookTrailLesson;
use Modules\Appointment\Repositories\Interfaces\BookingRepositoryInterface;

class BookingController extends Controller
{
    protected $bookingRepository;
    protected $instructorRepository;

    public function __construct(
        BookingRepositoryInterface $bookingRepository
    )
    {
        $this->bookingRepository = $bookingRepository;
    }

    public function index(Request $request)
    {
        $data = $this->bookingRepository->index($request->except('_token'));
        return view('appointment::booking.booking_list', $data);
    }

    public function bookedUser(Request $request)
    {
        $data = $this->bookingRepository->bookedUser($request->all());
        return view('appointment::booking.booked_user', $data);
    }

    public function shareLink(Request $request)
    {
        $this->bookingRepository->shareLink($request->all());
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }

    public function bookTrailLesson($slug)
    {
        $this->bookingRepository->bookTrailLesson($slug);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }

    public function trailLessonList(Request $request)
    {
        $data = $this->bookingRepository->trailLesson($request->except('_token'));
        return view('appointment::booking.trail_lesson_list', $data);
    }

    public function trailLessonDelete($id)
    {
        $this->bookingRepository->trailLessonDelete($id);

        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();    }

    public function approve($approve_id)
    {
        $this->bookingRepository->approve($approve_id);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }

    public function reject($reject_id)
    {
        $this->bookingRepository->reject($reject_id);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }

    public function create()
    {
        return view('appointment::create');
    }

    public function store(Request $request)
    {
        $this->bookingRepository->store($request->except('_token'));
        return response()->json(['msg' => 'Operation Successful']);
    }


}
