<?php

namespace Modules\Appointment\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Appointment\Entities\Schedule;

class BookTrailLesson extends Model
{
    use Tenantable;

    protected $guarded = ['id'];

    public function schedule()
    {
        return $this->belongsTo(Schedule::class, 'schedule_id', 'id')->withDefault();
    }
    public function instructorInfo()
    {
        return $this->belongsTo(User::class, 'instructor_id', 'id')->withDefault();
    }
    public function userInfo()
    {
        return $this->belongsTo(User::class, 'student_id', 'id')->withDefault();
    }
}
