<?php

namespace Modules\Appointment\Database\Seeders;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Modules\Appointment\Entities\InstructorTeachingCategory;

class AppointmentDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();


        $users = User::where('role_id', 2)->get();
        foreach ($users as $user) {
            $user->is_available = 1;
            $user->slug = Str::slug($user->name);
            $user->available_msg = 'I am available';
            $user->hour_rate = rand(10, 20);
            $user->save();

            InstructorTeachingCategory::where('instructor_id', $user->id)->delete();
            $categoryStore = new InstructorTeachingCategory();
            $categoryStore->instructor_id = $user->id;
            $categoryStore->category_id = rand(1, 15);
            $categoryStore->level_id = rand(1, 4);
            $categoryStore->created_by = 1;
            $categoryStore->save();
        }
    }
}
