<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\Appointment\Entities\AppointmentSettings;

class CreateAppointmentSettingsTable extends Migration
{
    public function up()
    {
        Schema::create('appointment_settings', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('access')->nullable()->comment('1=admin 0=individual')->default(0);
            $table->tinyInteger('lesson_booked')->nullable()->default(1);
            $table->tinyInteger('popular')->nullable()->default(1);
            $table->tinyInteger('trail_lesson')->nullable()->default(1);
            $table->tinyInteger('review_option')->nullable()->default(0);
            $table->tinyInteger('submit_review')->nullable()->default(0);
            $table->tinyInteger('link_after_submit')->nullable()->default(1);
            $table->tinyInteger('status_admin')->nullable()->default(1);
            $table->tinyInteger('number_of_student')->nullable()->default(0);
            $table->integer('user_id')->nullable();
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
        AppointmentSettings::create(['user_id' => 1]);
    }


    public function down()
    {
        Schema::dropIfExists('appointment_settings');
    }
}
