<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTimeSlotsTable extends Migration
{
    public function up()
    {
        Schema::create('time_slots', function (Blueprint $table) {
            $table->id();
            $table->string('type')->nullable();
            $table->string('title')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('user_id')->nullable();
            $table->tinyInteger('status')->nullable()->default(1);
            $table->tinyInteger('is_break')->nullable()->comment('1 = yes, 0 = no');
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('time_slots');
    }
}
