<form class="form-area contact-form" id="myForm"
      action="<?php echo e(route('contactMsgSubmit')); ?>"
      method="post">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="col-lg-12">

            <div class="row">

                <div class="col-md-6">
                    <div class="contact-form-element">
                        <input name="name"
                                onfocus="this.placeholder = ''"
                                class="primary_input" type="text" required
                               value="<?php echo e(old('name')); ?>">
                        <label class="primary_label"><?php echo e(__('frontend.Name')); ?></label>
                        <span class="text-danger" role="alert"><?php echo e($errors->first('name')); ?></span>
                    </div>
                </div>



                <div class="col-md-6">
                    <div class="contact-form-element">
                        <input name="email" required
                                pattern="[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{1,63}$"
                               onfocus="this.placeholder = ''"
                                class="primary_input"
                               type="email" value="<?php echo e(old('email')); ?>">
                        <label class="primary_label"><?php echo e(__('frontend.Email Address')); ?></label>
                        <span class="text-danger" role="alert"><?php echo e($errors->first('email')); ?></span>
                    </div>
                </div>


                <div class="col-md-12">
                    <div class="contact-form-element">
                        <input name="subject" required
                               onfocus="this.placeholder = ''"
                               class="primary_input" type="text"
                               value="<?php echo e(old('subject')); ?>">
                        <label class="primary_label"><?php echo e(__('frontend.Subject')); ?></label>
                        <span class="text-danger" role="alert"><?php echo e($errors->first('subject')); ?></span>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="contact-form-element">
                    <textarea required class="primary_textarea mb-0" name="message"
                              onfocus="this.placeholder = ''"
                    ><?php echo e(old('message')); ?></textarea>
                        <label class="primary_label"><?php echo e(__('frontend.Message')); ?></label>
                        <span class="text-danger" role="alert"><?php echo e($errors->first('message')); ?></span>
                    </div>
                </div>


            </div>


        </div>

        <div class="col-12 mt_10 mb_20">


            <?php if(saasEnv('NOCAPTCHA_FOR_CONTACT')=='true'): ?>
                <input type="hidden" name="hasCaptcha"
                       value="<?php echo e(saasEnv('NOCAPTCHA_FOR_CONTACT')); ?>">
                <?php if(saasEnv('NOCAPTCHA_IS_INVISIBLE')=="true"): ?>
                    <?php echo NoCaptcha::display(["data-size"=>"invisible"]); ?>

                    <?php echo NoCaptcha::renderJs(); ?>

                <?php else: ?>
                    <?php echo NoCaptcha::display(); ?>

                    <?php echo NoCaptcha::renderJs(); ?>

                <?php endif; ?>

                <?php if($errors->has('g-recaptcha-response')): ?>
                    <span class="text-danger"
                          role="alert"><?php echo e($errors->first('g-recaptcha-response')); ?></span>
                <?php endif; ?>
            <?php endif; ?>


        </div>
        <div class="col-lg-12 text-start">

            <div class="alert-msg"></div>


            <?php if(saasEnv('NOCAPTCHA_FOR_CONTACT')=='true' && saasEnv('NOCAPTCHA_IS_INVISIBLE')=="true"): ?>
                <button type="button"
                        class="g-recaptcha theme_btn small_btn submit-btn w-100 text-center"
                        data-sitekey="<?php echo e(saasEnv('NOCAPTCHA_SITEKEY')); ?>"
                        data-size="invisible"
                        data-callback="onSubmit"
                >
                    <?php echo e(__('frontend.Send Message')); ?>

                </button>

                <script src="https://www.google.com/recaptcha/api.js"
                        async
                        defer></script>
                <script>
                    function onSubmit(token) {
                        document.getElementById("myForm").submit();
                    }
                </script>
            <?php else: ?>

                <button type="submit"
                        class="theme_btn small_btn submit-btn w-100 text-center">
                    <?php echo e(__('frontend.Send Message')); ?>

                </button>
            <?php endif; ?>

        </div>
    </div>
</form>


<script>
    $(document).ready(function () {
        $(".contact-form input, .contact-form textarea").on("change", function () {
            let value = $(this).val();

            if (value.length > 0) {
                $(this).closest(".contact-form-element").addClass("has-content");
            } else {
                $(this).closest(".contact-form-element").removeClass("has-content");
            }
        });
    });

</script>
<?php /**PATH /home/minialms/app.minialms.com/resources/views/frontend/infixlmstheme/snippets/components/_contact_form.blade.php ENDPATH**/ ?>