<?php $__env->startSection('mainContent'); ?>
    <style>
        @media only screen and (min-width: 992px) {
            .drawflow-node.ans {
                margin-right: 0 !important;
            }
        }

        .drawflow .drawflow-node {
            width: calc(100% / 12 * 5) !important;
        }

        .drawflow .drawflow-node .primary_input_field {
            width: 180px;
            align-self: start;
        }

        .drawflow .drawflow-node .input {
            z-index: 999 !important;
        }

        .thumb_img_div {
            height: 50px !important;
        }

        .thumb_img_div img {
            height: 50px !important;
        }

        .drawflow {
            min-width: 1500px;
        }

        .drawflow_content_node .primary_input.single-uploader {
            display: flex;
        }

        .ansNode .drawflow_content_node .primary_input.single-uploader {
            display: flex;
            flex-direction: row-reverse;
        }

        .drawflow_content_node .product_image_all_div {
            margin-top: 0;
            height: 46px;
            width: fit-content;
        }

        .drawflow_content_node .product_image_all_div img {
            height: 46px !important;
            width: 80px !important;
            object-fit: cover;
        }

        .drawflow_content_node .thumb_img_div {
            height: 46px !important;
            min-width: 90px !important;
            border: 0 !important;
        }

        .drawflow_content_node .primary_file_uploader {
            flex-grow: 1;
        }

        html[dir='rtl'] #drawflow {
            direction: ltr;
        }

        html[dir='rtl'] .drawflow .connection {
            right: auto;
            left: 0;
        }

        .drawflow-node .product_image_all_div {
            margin-left: 16px;
        }

        html[dir="rtl"] .drawflow-node .product_image_all_div {
            margin-right: 16px;
            margin-left: 0;
        }

    </style>
    <?php echo generateBreadcrumb(); ?>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <?php if(isset($bank)): ?>
                <?php if(permissionCheck('question-bank.store')): ?>
                    <div class="row">
                        <div class="offset-lg-10 col-lg-2 text-end col-md-12 mb-20">

                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-12">


                            <?php if(isset($bank)): ?>

                                <form method="POST" action="<?php echo e(route('question-bank-update', $bank->id)); ?>"
                                      class="form-horizontal" enctype="multipart/form-data" id="question_bank">
                                    <?php echo method_field('PUT'); ?>
                                    <?php echo csrf_field(); ?>
                                    <?php else: ?>
                                        <?php if(permissionCheck('question-bank.store')): ?>
                                            <form method="POST" action="<?php echo e(route('question-bank.store')); ?>"
                                                  class="form-horizontal" enctype="multipart/form-data"
                                                  id="question_bank">
                                                <?php echo csrf_field(); ?>
                                                <?php endif; ?>
                                                <?php endif; ?>
                                                <input type="hidden" name="url" id="url" value="<?php echo e(URL::to('/')); ?>">

                                                <input type="hidden" name="connection" id="connection"
                                                       value="<?php echo e(old('connection',isset($bank) && $bank->type=='X'?$bank->connection:null)); ?>">
                                                

                                                <div class="white-box ">
                                                    <div class="add-visitor">
                                                        <div class="row row-gap-3">
                                                            <div class="col-lg-4">
                                                                <?php
                                                                    if(isset($bank)){
                                                                         request()->replace(['group'=>$bank->q_group_id]);
                                                                    }
                                                                ?>
                                                                <label class="primary_input_label"
                                                                       for="groupInput"><?php echo e(__('quiz.Group')); ?> <span
                                                                        class="required_mark">*</span></label>
                                                                <select <?php echo e($errors->has('group') ? ' autofocus' : ''); ?>

                                                                        class="primary_select<?php echo e($errors->has('group') ? ' is-invalid' : ''); ?>"
                                                                        name="group" id="groupInput">
                                                                    <option
                                                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Group')); ?> "
                                                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Group')); ?>

                                                                    </option>
                                                                    <?php if(isModuleActive('AdvanceQuiz')): ?>
                                                                        <?php $__currentLoopData = $groups->where('parent_id',0); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php echo $__env->make('advancequiz::group._single_select_option_id',['group'=>$group,'level'=>1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php else: ?>
                                                                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(isset($bank)): ?>
                                                                                <option
                                                                                    value="<?php echo e($group->id); ?>" <?php echo e($group->id == $bank->q_group_id? 'selected': ''); ?>><?php echo e($group->title); ?></option>
                                                                            <?php else: ?>
                                                                                <option
                                                                                    value="<?php echo e($group->id); ?>" <?php echo e(old('group')!=''? (old('group') == $group->id? 'selected':''):''); ?> ><?php echo e($group->title); ?></option>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php endif; ?>

                                                                </select>

                                                            </div>
                                                            <?php if(isModuleActive('AdvanceQuiz')): ?>
                                                                <div class="col-lg-4">
                                                                    <label class="primary_input_label"
                                                                           for="level"><?php echo e(__('quiz.Question Level')); ?> </label>
                                                                    <select
                                                                        <?php echo e($errors->has('level') ? ' autofocus' : ''); ?>

                                                                        class="primary_select <?php echo e($errors->has('level') ? ' is-invalid' : ''); ?>"
                                                                        id="level" name="level">

                                                                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(isset($bank)): ?>
                                                                                <option
                                                                                    value="<?php echo e($level->id); ?>" <?php echo e($bank->level == $level->id? 'selected': ''); ?>><?php echo e($level->title); ?></option>
                                                                            <?php else: ?>
                                                                                <option
                                                                                    value="<?php echo e($level->id); ?>" <?php echo e(old('level')!=''? (old('level') == $level->id? 'selected':''):''); ?>><?php echo e($level->title); ?></option>
                                                                            <?php endif; ?>

                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>

                                                                </div>
                                                                <div class="col-lg-4 mt-30-md" id="preConditionQus">
                                                                    <label class="primary_input_label"
                                                                           for="subcategory_id"><?php echo e(__('quiz.Pre-Condition Question')); ?></label>
                                                                    <select
                                                                        <?php echo e($errors->has('pre_condition') ? ' autofocus' : ''); ?>

                                                                        class="primary_select<?php echo e($errors->has('pre_condition') ? ' is-invalid' : ''); ?> select_section"
                                                                        id="pre_condition" name="pre_condition">

                                                                        <option value="0"
                                                                                <?php if(isset($bank) && $bank->pre_condition==0): ?>
                                                                                    selected
                                                                            <?php endif; ?>
                                                                        ><?php echo e(__('common.No')); ?></option>

                                                                        <option value="1"
                                                                                <?php if(isset($bank) && $bank->pre_condition==1): ?>
                                                                                    selected
                                                                            <?php endif; ?>
                                                                        ><?php echo e(__('common.Yes')); ?></option>
                                                                    </select>

                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="col-lg-4">
                                                                <label id="QuestionTypeLevel"
                                                                       class="primary_input_label <?php echo e(isModuleActive('AdvanceQuiz')?'mt-25':''); ?>"
                                                                       for="question-type"><?php echo e(__('quiz.Question Type')); ?>

                                                                    <span
                                                                        class="required_mark">*</span></label>
                                                                <select
                                                                    <?php echo e($errors->has('question_type') ? ' autofocus' : ''); ?>

                                                                    class="primary_select<?php echo e($errors->has('question_type') ? ' is-invalid' : ''); ?>"
                                                                    name="question_type" id="question-type">
                                                                    <option data-display="<?php echo e(__('quiz.Question Type')); ?> "
                                                                            value=""><?php echo e(__('quiz.Question Type')); ?>

                                                                    </option>

                                                                    <option
                                                                        value="M" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'M'? 'selected': ''); ?>> <?php echo e(__('quiz.Multiple Choice')); ?></option>

                                                                    <option
                                                                        value="O" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'O'? 'selected': ''); ?> > <?php echo e(__('quiz.Sorting')); ?> </option>

                                                                    <option
                                                                        value="X" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'X'? 'selected': ''); ?> > <?php echo e(__('quiz.Matching')); ?> </option>

                                                                    <option
                                                                        value="C" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'C'? 'selected': ''); ?> > <?php echo e(__('quiz.Cloze question')); ?> </option>

                                                                    <option
                                                                        value="P" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'P'? 'selected': ''); ?> > <?php echo e(__('quiz.Puzzle')); ?> </option>

                                                                    <option
                                                                        value="S" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'S'? 'selected': ''); ?>> <?php echo e(__('quiz.Short Answer')); ?> </option>
                                                                    <option
                                                                        value="L" <?php echo e(old('question_type',isset($bank)? $bank->type:'') == 'L'? 'selected': ''); ?>> <?php echo e(__('quiz.Long Answer')); ?> </option>
                                                                </select>

                                                            </div>
                                                            <div class="col-lg-2">
                                                                <div
                                                                    class="input-effect <?php echo e(isModuleActive('AdvanceQuiz')?'mt-25':''); ?>">
                                                                    <label
                                                                        class="primary_input_label"> <?php echo e(__('quiz.Marks')); ?>

                                                                        <span
                                                                            class="required_mark">*</span>
                                                                    </label>
                                                                    <input
                                                                        <?php echo e($errors->has('marks') ? ' autofocus' : ''); ?>

                                                                        class="primary_input_field name<?php echo e($errors->has('marks') ? ' is-invalid' : ''); ?>"
                                                                        type="number" name="marks"
                                                                        value="<?php echo e(isset($bank)? $bank->marks:(old('marks')!=''?(old('marks')):'')); ?>">
                                                                    <span class="focus-border"></span>

                                                                </div>
                                                            </div>

                                                            <div class="col-lg-2" id="shuffleBox">
                                                                <div
                                                                    class="input-effect <?php if(isModuleActive('AdvanceQuiz')): ?>  mt-25 <?php endif; ?>">
                                                                    <label
                                                                        class="primary_input_label mt-1"> <?php echo e(__('quiz.Shuffle Answer')); ?>

                                                                        <span
                                                                            class="required_mark">*</span>
                                                                    </label>
                                                                    <select
                                                                        <?php echo e($errors->has('shuffle') ? ' autofocus' : ''); ?>

                                                                        class="primary_select<?php echo e($errors->has('shuffle') ? ' is-invalid' : ''); ?>"
                                                                        name="shuffle" id="shuffle">
                                                                        <option
                                                                            value="1" <?php echo e(isset($bank)? $bank->shuffle ==1? 'selected': '' : 'selected'); ?>> <?php echo e(__('common.Yes')); ?></option>
                                                                        <option
                                                                            value="0" <?php echo e(isset($bank)? $bank->shuffle ==0? 'selected': '' : ''); ?>> <?php echo e(__('common.No')); ?></option>

                                                                    </select>

                                                                </div>
                                                            </div>


                                                            <div class="col-xl-4">
                                                                <div class=" mt-25">
                                                                    <?php if (isset($component)) { $__componentOriginal3c189c37dfafa3e6853f94906c245d36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3c189c37dfafa3e6853f94906c245d36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.upload-file','data' => ['name' => 'image','type' => 'image','mediaId' => ''.e(isset($bank)?$bank->image_media?->media_id:'').'','label' => ''.e(__('common.Image')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('upload-file'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'image','type' => 'image','media_id' => ''.e(isset($bank)?$bank->image_media?->media_id:'').'','label' => ''.e(__('common.Image')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $attributes = $__attributesOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $component = $__componentOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__componentOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
                                                                </div>

                                                            </div>
                                                        </div>
                                                        <div class="row mt-25">
                                                            <div class="col-lg-12">
                                                                <div class="input-effect">
                                                                    <label
                                                                        class="primary_input_label mt-1"> <?php echo e(__('quiz.Question')); ?>

                                                                        <span
                                                                            class="required_mark">*</span></label>
                                                                    <textarea
                                                                        class="textArea lms_summernote <?php echo e(@$errors->has('details') ? ' is-invalid' : ''); ?>"
                                                                        cols="30" rows="10"
                                                                        name="question"><?php echo e(isset($bank)? $bank->question:(old('question')!=''?(old('question')):'')); ?></textarea>

                                                                    <span class="focus-border textarea"></span>

                                                                </div>
                                                            </div>
                                                        </div>


                                                        <?php
                                                            if((isset($bank) && $bank->type == "M") || old('question_type') == "M"){
                                                                 $multiple_choice = "";
                                                                 $multiple_options = "";
                                                             }

                                                              if((isset($bank) && $bank->type == "X") || old('question_type') == "X"){
                                                                 $matching_choice = "";
                                                                 $matching_options = "";
                                                             }

                                                              if((isset($bank) && $bank->type == "O") || old('question_type') == "O"){
                                                                     $sorting_choice = "";
                                                                     $sorting_options = "";
                                                                 }

                                                              if((isset($bank) && $bank->type == "P") || old('question_type') == "P"){
                                                                 $puzzle_choice = "";
                                                                 $puzzle_options = "";
                                                             }
                                                        ?>
                                                        <div class="multiple-choice">
                                                            <div class="row  mt-25 align-items-end">
                                                                <div class="col-lg-8">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Options')); ?>

                                                                            <span
                                                                                class="required_mark">*</span></label>
                                                                        <input
                                                                            <?php echo e($errors->has('number_of_option') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('number_of_option') ? ' is-invalid' : ''); ?>"
                                                                            type="number" name="number_of_option"
                                                                            autocomplete="off"
                                                                            id="number_of_option"
                                                                            value="<?php echo e(isset($bank)? $bank->number_of_option: ''); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-2 mt-40 mb-2">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="matching-choice ">
                                                            <div class="row  mt-25">
                                                                <div class="col-lg-3">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Options')); ?>

                                                                            <span
                                                                                class="required_mark">*</span></label>
                                                                        <input
                                                                            <?php echo e($errors->has('number_of_option') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('number_of_option') ? ' is-invalid' : ''); ?>"
                                                                            type="number" name="number_of_qus"
                                                                            autocomplete="off"
                                                                            id="number_of_qus"
                                                                            data-title="<?php echo e(__('quiz.Option')); ?>"
                                                                            value="<?php echo e(isset($bank)? $bank->number_of_qus: ''); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-3 mt-40">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-qus-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>

                                                                <div class="col-lg-3">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Answer')); ?>

                                                                            <span
                                                                                class="required_mark">*</span></label>
                                                                        <input
                                                                            <?php echo e($errors->has('number_of_ans') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('number_of_ans') ? ' is-invalid' : ''); ?>"
                                                                            type="number" name="number_of_ans"
                                                                            autocomplete="off"
                                                                            id="number_of_ans"
                                                                            data-title="<?php echo e(__('quiz.Answer')); ?>"
                                                                            value="<?php echo e(old('number_of_ans',isset($bank)? $bank->number_of_ans: '')); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-3 mt-40">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-ans-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="sorting-choice">
                                                            <div class="row  mt-25 align-items-end">
                                                                <div class="col-lg-8">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Options')); ?>

                                                                            <span
                                                                                class="required_mark">*</span></label>
                                                                        <input
                                                                            <?php echo e($errors->has('number_of_sorting_option') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('number_of_sorting_option') ? ' is-invalid' : ''); ?>"
                                                                            type="number"
                                                                            name="number_of_sorting_option"
                                                                            autocomplete="off"
                                                                            id="number_of_sorting_option"
                                                                            value="<?php echo e(isset($bank)? $bank->number_of_option: ''); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-2 mt-40 mb-2">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-sorting-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="cloze-choice">
                                                            <div class="row  mt-25 align-items-end">
                                                                <div class="col-lg-8">
                                                                    <div class="input-effect">
                                                                        <div class="instruction-box pt-3 pb-3">
                                                                            <strong><?php echo e(__('quiz.Instruction')); ?>:</strong>
                                                                            <?php echo e(__('quiz.Please enter your question in the following format')); ?>

                                                                            :
                                                                            use <code>[1]</code>, <code>[2]</code>, etc.
                                                                            to indicate the
                                                                            blanks.
                                                                            <br>Example: "The capital of France is
                                                                            <code>[1]</code>."
                                                                        </div>

                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Blanks')); ?>

                                                                            <span
                                                                                class="required_mark">*</span>
                                                                        </label>

                                                                        <input
                                                                            <?php echo e($errors->has('number_of_cloze_option') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('number_of_cloze_option') ? ' is-invalid' : ''); ?>"
                                                                            type="number" name="number_of_cloze_option"
                                                                            autocomplete="off"
                                                                            id="number_of_cloze_option"
                                                                            value="<?php echo e(isset($bank)? $bank->number_of_option: ''); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-2 mt-40 mb-2">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-cloze-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="puzzle-choice ">
                                                            <div class="row  mt-25">
                                                                <div class="col-lg-3">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Options')); ?>

                                                                            <span
                                                                                class="required_mark">*</span></label>
                                                                        <input
                                                                            <?php echo e($errors->has('puzzle_number_of_qus') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('puzzle_number_of_qus') ? ' is-invalid' : ''); ?>"
                                                                            type="number" name="puzzle_number_of_qus"
                                                                            autocomplete="off"
                                                                            id="puzzle_number_of_qus"
                                                                            data-title="<?php echo e(__('quiz.Option')); ?>"
                                                                            value="<?php echo e(isset($bank)? $bank->number_of_qus: ''); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-3 mt-40">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-puzzle-qus-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>

                                                                <div class="col-lg-3">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Number Of Answer')); ?>

                                                                            <span
                                                                                class="required_mark">*</span></label>
                                                                        <input
                                                                            <?php echo e($errors->has('puzzle_number_of_ans') ? ' autofocus' : ''); ?>

                                                                            class="primary_input_field name<?php echo e($errors->has('puzzle_number_of_ans') ? ' is-invalid' : ''); ?>"
                                                                            type="number" name="puzzle_number_of_ans"
                                                                            autocomplete="off"
                                                                            id="puzzle_number_of_ans"
                                                                            data-title="<?php echo e(__('quiz.Answer')); ?>"
                                                                            value="<?php echo e(old('puzzle_number_of_ans',isset($bank)? $bank->number_of_ans: '')); ?>">
                                                                        <span class="focus-border"></span>

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-3 mt-40">
                                                                    <button type="button"
                                                                            class="primary-btn small fix-gr-bg"
                                                                            id="create-puzzle-ans-option"><?php echo e(__('quiz.Create')); ?> </button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        
                                                        <div class="multiple-options questionBoxDiv"
                                                             id="<?php echo e(isset($multiple_options)? "": 'multiple-options'); ?>">
                                                            <?php
                                                                $i=0;
                                                                $multiple_options = [];

                                                                if(isset($bank)){
                                                                    if($bank->type == "M"){
                                                                        $multiple_options = $bank->questionMuInSerial;
                                                                    }
                                                                }
                                                            ?>
                                                            <?php $__currentLoopData = $multiple_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $multiple_option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                <?php $i++; ?>
                                                                <div class='row  mt-25'>
                                                                    <div class='col-lg-10'>
                                                                        <div class='input-effect'>
                                                                            <input class='primary_input_field name'
                                                                                   type='text'
                                                                                   name='option[]' autocomplete='off'
                                                                                   required
                                                                                   value="<?php echo e($multiple_option->title); ?>">
                                                                            <span class='focus-border'></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class='col-lg-2 mt-40'>
                                                                        <label class="primary_checkbox d-flex mr-12 "
                                                                               for="option_check_<?php echo e($i); ?>">
                                                                            <input type="checkbox"
                                                                                   <?php if($multiple_option->status==1): ?> checked
                                                                                   <?php endif; ?> id="option_check_<?php echo e($i); ?>"
                                                                                   name="option_check_<?php echo e($i); ?>" value="1">
                                                                            <span class="checkmark"></span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>

                                                        <div class="sorting-options questionBoxDiv"
                                                             id="<?php echo e(isset($multiple_options)? "": 'multiple-options'); ?>">
                                                            <?php
                                                                $i=0;
                                                                $sorting_options = [];

                                                                if(isset($bank)){
                                                                    if($bank->type == "O"){
                                                                        $sorting_options = $bank->questionSortingOptionsSerial;
                                                                    }
                                                                }
                                                            ?>
                                                            <?php $__currentLoopData = $sorting_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$sorting_option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                <div class='row  mt-25' id='option-<?php echo e($key); ?>'>
                                                                    <div class='col-lg-10'>
                                                                        <div class='input-effect'>
                                                                            <input class='primary_input_field name'
                                                                                   type='text'
                                                                                   name='sorting_option[]'
                                                                                   autocomplete='off' required
                                                                                   value="<?php echo e($sorting_option->title); ?>">
                                                                            <span class='focus-border'></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class='col-lg-2 mt-15 '>
                                                                        <span class='drag-handle' style='cursor: move;'>&#9776;</span>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>

                                                        <div class="matching-options "
                                                             id="<?php echo e(isset($matching_choice)? "": 'matching-options'); ?>">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div id="drawflow" ondrop="drop(event)"
                                                                         ondragover="allowDrop(event)"
                                                                         style="width: 100%;overflow: auto">


                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="cloze-options QA_section   table-responsive">
                                                            <table class=" QA_table table table-borderless mt-3">
                                                                <thead>
                                                                <tr>
                                                                    <th class="p-2"><?php echo e(trans('quiz.Number')); ?></th>
                                                                    <th class="p-2 w-75"><?php echo e(trans('quiz.Options')); ?></th>
                                                                    <th class="p-2"><?php echo e(trans('common.Action')); ?></th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <?php
                                                                    $i = 0;
                                                                    $cloze_options = [];

                                                                    if (isset($bank) && $bank->type == "C") {
                                                                        $cloze_options = $bank->questionMuInSerial;
                                                                    }
                                                                ?>
                                                                <?php if(isset($cloze_options) && count($cloze_options) > 0): ?>
                                                                    <?php $__currentLoopData = $cloze_options->groupBy('group'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cloze_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <tr class='option-row'>
                                                                            <td class='p-2'><?php echo e($loop->iteration); ?></td>
                                                                            <td class='p-2'>
                                                                                <div class='options-container'
                                                                                     data-row-number='<?php echo e($loop->iteration); ?>'>
                                                                                    <?php $__currentLoopData = $cloze_group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <div
                                                                                            class='input-effect mb-2 d-flex align-items-center'>
                                                                                            
                                                                                            <input
                                                                                                class='primary_input_field name'
                                                                                                placeholder='Option <?php echo e($loop->iteration); ?>'
                                                                                                type='text'
                                                                                                name='cloze_option[<?php echo e($loop->parent->iteration); ?>][]'
                                                                                                value="<?php echo e($option->title); ?>"
                                                                                                autocomplete='off'
                                                                                                required>

                                                                                            
                                                                                            <label
                                                                                                class='primary_checkbox d-flex ms-3'>
                                                                                                <input
                                                                                                    name='cloze_answer[<?php echo e($loop->parent->iteration); ?>]'
                                                                                                    value='<?php echo e($loop->iteration); ?>'
                                                                                                    type='radio' <?php echo e($option->status ? 'checked' : ''); ?>>
                                                                                                <span
                                                                                                    class='checkmark'></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </div>
                                                                            </td>
                                                                            <td class='p-2'>
                                                                                <div class='d-flex'>
                                                                                    <button type='button'
                                                                                            class='primary-btn small fix-gr-bg add-option-btn'>
                                                                                        <i class='ti ti-plus m-0 p-0'></i>
                                                                                    </button>
                                                                                    <button type='button'
                                                                                            class='primary-btn small fix-gr-bg remove-option-btn ms-2'>
                                                                                        <i class='ti ti-trash m-0 p-0'></i>
                                                                                    </button>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                                </tbody>


                                                            </table>

                                                        </div>


                                                        <div class="puzzle-options">


                                                            <?php
                                                                $i=0;
                                                                $puzzle_options = [];

                                                                $puzzleQus =[];
                                                                $puzzleAns =[];
                                                                if(isset($bank) && $bank->type == "P"){
                                                                    $puzzle_options = $bank->questionSortingOptionsSerial;
                                                                    $puzzleQus = $puzzle_options->where('type',1);
                                                                    $puzzleAns = $puzzle_options->where('type',0);
                                                                }
                                                            ?>

                                                            <div class="row">
                                                                <div class="col-6 mt-3" id="puzzleQus">
                                                                    <?php
                                                                        $puzzleQusIndex=0;
                                                                    ?>
                                                                    <?php $__currentLoopData = $puzzleQus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class='row optionType mb-3' data-type='qus'
                                                                             data-index='<?php echo e($puzzleQusIndex); ?>'>
                                                                            <div class='col-lg-12 optionTitle'>
                                                                                <div class='input-group'>
                                                                                    <input
                                                                                        class='form-control option_title'
                                                                                        type='text'
                                                                                        value="<?php echo e($qus->title); ?>"
                                                                                        name='puzzle_qus[<?php echo e($puzzleQusIndex); ?>]'
                                                                                        placeholder='Enter Question <?php echo e($puzzleQusIndex + 1); ?>'
                                                                                        required>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <?php
                                                                            $puzzleQusIndex++;
                                                                        ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                                <div class="col-6 mt-3" id="puzzleAns">
                                                                    <?php
                                                                        $puzzleAnsIndex=0;
                                                                    ?>
                                                                    <?php $__currentLoopData = $puzzleAns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class='row optionType mb-3' data-type='ans'
                                                                             data-index='<?php echo e($puzzleAnsIndex); ?>'>
                                                                            <div class='col-lg-12 optionTitle'>
                                                                                <div class='input-group'>
                                                                                    <input
                                                                                        class='form-control ans_title'
                                                                                        type='text'
                                                                                        value="<?php echo e($ans->title); ?>"
                                                                                        name='puzzle_ans[<?php echo e($puzzleAnsIndex); ?>]'
                                                                                        placeholder='Enter Answer <?php echo e($puzzleAnsIndex + 1); ?>'>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <?php
                                                                            $puzzleAnsIndex++;
                                                                        ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-12" id="puzzleCombine">
                                                                    <?php if(isset($bank)): ?>
                                                                        <div class="col-12">
                                                                            <h4><?php echo e(__('quiz.Correct option')); ?></h4>
                                                                        </div>
                                                                        <?php
                                                                            $puzzleQusIndex=0;
                                                                        ?>
                                                                        <?php $__currentLoopData = $puzzleQus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $qus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="row mb-5">
                                                                                <div class="col-lg-6">
                                                                                    <label><?php echo e(__('quiz.Question')); ?> <?php echo e($puzzleQusIndex=$puzzleQusIndex + 1); ?>

                                                                                        :</label>
                                                                                </div>
                                                                                <div
                                                                                    class="col-lg-6 d-flex flex-column gap-3">
                                                                                    <?php
                                                                                        $puzzleAnsIndex=0;
                                                                                    ?>
                                                                                    <?php $__currentLoopData = $puzzleAns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $ans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <?php
                                                                                            $checkboxId = "questionReview_{$i}_{$j}";
                                                                                            $hasItem= $bank->matchingOptions->where('option_id',$qus->id)->where('answer_id',$ans->id)->first();
                                                                                        ?>
                                                                                        <label
                                                                                            class="primary_checkbox d-flex text-nowrap mr-12">
                                                                                            <input
                                                                                                name="question_review[<?php echo e($i); ?>][<?php echo e($puzzleAnsIndex); ?>]"
                                                                                                value="<?php echo e($puzzleAnsIndex); ?>"
                                                                                                id="<?php echo e($checkboxId); ?>"
                                                                                                <?php echo e($hasItem? 'checked': ''); ?>

                                                                                                type="checkbox">
                                                                                            <span
                                                                                                class="checkmark"></span>
                                                                                            <span
                                                                                                class="ms-2"><?php echo e(trans('quiz.Answer').' ' . ($puzzleAnsIndex =$puzzleAnsIndex+1)); ?></span>
                                                                                        </label>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </div>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        


                                                        <div class="">
                                                            <div class="row  mt-25">
                                                                <div class="col-lg-12">
                                                                    <div class="input-effect">
                                                                        <label
                                                                            class="primary_input_label mt-1"> <?php echo e(__('quiz.Explanation')); ?> </label>
                                                                        <textarea
                                                                            class="textArea lms_summernote <?php echo e(@$errors->has('details') ? ' is-invalid' : ''); ?>"
                                                                            cols="10" rows="10"
                                                                            name="explanation"><?php echo e(isset($bank)? $bank->explanation:(old('explanation')!=''?(old('explanation')):'')); ?></textarea>

                                                                        <span class="focus-border textarea"></span>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row mt-3">
                                                            <div class="col-lg-12 text-center">
                                                                <button class="primary-btn fix-gr-bg questionSubmitBtn"
                                                                        data-bs-toggle="tooltip"
                                                                        type="submit">
                                                                    <i class="ti-check"></i>
                                                                    <?php echo e(isset($bank) ? __('common.Update') : __('common.Save')); ?> <?php echo e(__('quiz.Question')); ?>

                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <script>

        $("body").on('change', '.fileUpload1', function () {
            let placeholder = $(this).closest(".primary_file_uploader").find(".filePlaceholder");
            let fileInput = event.srcElement;
            placeholder.val(fileInput.files[0].name);
            console.log(fileInput.files[0].name);
            $('.removeImage1').removeClass('d-none');
        });


        $(document).on("click", ".questionSubmitBtn", function (e) {

            e.preventDefault();
            let type = $('#question-type').val();
            if (type == 'M') {
                let div = $('.questionBoxDiv');
                let count = div.find('[type=checkbox]:checked').length;
                let errorOptionCount = 0;

                if (count < 1) {
                    toastr.error('<?php echo e(__('common.At least one correct answer is required')); ?> ', '<?php echo e(__('common.Error')); ?>');
                    return false;
                }

                $('input[name="option[]"]').each(function (index) {
                    if ($(this).val().trim() == "") {
                        errorOptionCount++;
                    }
                });

                if (errorOptionCount != 0) {
                    toastr.error('<?php echo e(__("quiz.Option title is required")); ?>', '<?php echo e(__("common.Error")); ?>');
                    return false;
                }

            } else if (type == 'X') {
                let connection = $('#connection').val().length;
                if (connection == 0) {
                    toastr.error('<?php echo e(__('common.At least one correct answer is required')); ?> ', '<?php echo e(__('common.Error')); ?>');
                    return false;
                }
                let errorCount = 0;
                $('.option_title').each(function (index) {
                    if ($(this).val().trim() == "") {
                        errorCount++;
                        toastr.error('<?php echo e(__('quiz.Option title is required')); ?> ', '<?php echo e(__('common.Error')); ?>');
                    }
                });
                $('.ans_title').each(function (index) {
                    if ($(this).val().trim() == "") {
                        errorCount++;
                        toastr.error('<?php echo e(__('quiz.Answer title is required')); ?> ', '<?php echo e(__('common.Error')); ?>');
                    }
                });
                if (errorCount != 0) {
                    return false;
                }
                $('#data').val(JSON.stringify(editor.export()));
            }else if(type =='P'){
                let errorCount = 0;
                $('.option_title').each(function (index) {
                    if ($(this).val().trim() == "") {
                        errorCount++;
                        toastr.error('<?php echo e(__('quiz.Option title is required')); ?> ', '<?php echo e(__('common.Error')); ?>');
                    }
                });
                $('.ans_title').each(function (index) {
                    if ($(this).val().trim() == "") {
                        errorCount++;
                        toastr.error('<?php echo e(__('quiz.Answer title is required')); ?> ', '<?php echo e(__('common.Error')); ?>');
                    }
                });

                if (errorCount != 0) {
                    return false;
                }
            }
            $(this).closest('form').submit();
        });

        $('#question-type').change(function (e) {

            let type = $('#question-type').val();
            if (type == 'M') {
                $('.multiple-choice').show();
                $('.multiple-options').show();

                $('.sorting-choice').hide();
                $('.sorting-options').hide();
                $('.cloze-choice').hide();
                $('.cloze-options').hide();
                $('.matching-choice').hide();
                $('.matching-options').hide();
                $('.puzzle-choice').hide();
                $('.puzzle-options').hide();
                $('#shuffleBox').show();
                $('#preConditionQus').show();
                <?php if(isModuleActive('AdvanceQuiz')): ?>
                $('#QuestionTypeLevel').addClass('mt-25');
                <?php endif; ?>
            } else if (type == 'O') {
                $('.multiple-choice').hide();
                $('.multiple-options').hide();

                $('.sorting-choice').show();
                $('.sorting-options').show();
                $('.cloze-choice').hide();
                $('.cloze-options').hide();
                $('.matching-choice').hide();
                $('.matching-options').hide();
                $('.puzzle-choice').hide();
                $('.puzzle-options').hide();
                $('#shuffleBox').hide();
                $('#preConditionQus').hide();
                <?php if(isModuleActive('AdvanceQuiz')): ?>
                $('#QuestionTypeLevel').addClass('mt-25');
                <?php endif; ?>
            } else if (type == 'C') {
                $('.multiple-choice').hide();
                $('.multiple-options').hide();
                $('.sorting-choice').hide();
                $('.sorting-options').hide();
                $('.cloze-choice').show();
                $('.cloze-options').show();
                $('.matching-choice').hide();
                $('.matching-options').hide();
                $('.puzzle-choice').hide();
                $('.puzzle-options').hide();
                $('#shuffleBox').hide();
                $('#preConditionQus').hide();
                <?php if(isModuleActive('AdvanceQuiz')): ?>
                $('#QuestionTypeLevel').addClass('mt-25');
                <?php endif; ?>
            } else if (type == 'P') {
                $('.multiple-choice').hide();
                $('.multiple-options').hide();
                $('.sorting-choice').hide();
                $('.sorting-options').hide();
                $('.cloze-choice').hide();
                $('.cloze-options').hide();
                $('.matching-choice').hide();
                $('.matching-options').hide();
                $('.puzzle-choice').show();
                $('.puzzle-options').show();
                $('#shuffleBox').hide();
                $('#preConditionQus').hide();
                <?php if(isModuleActive('AdvanceQuiz')): ?>
                $('#QuestionTypeLevel').addClass('mt-25');
                <?php endif; ?>
            } else if (type == 'X') {
                $('.matching-choice').show();
                $('.matching-options').show();
                $('.sorting-choice').hide();
                $('.sorting-options').hide();
                $('.cloze-choice').hide();
                $('.cloze-options').hide();
                $('.multiple-choice').hide();
                $('.multiple-options').hide();
                $('.puzzle-choice').hide();
                $('.puzzle-options').hide();
                $('#shuffleBox').hide();
                $('#preConditionQus').show();
                <?php if(isModuleActive('AdvanceQuiz')): ?>
                $('#QuestionTypeLevel').addClass('mt-25');
                <?php endif; ?>
            } else {
                $('.sorting-choice').hide();
                $('.sorting-options').hide();
                $('.multiple-choice').hide();
                $('.multiple-options').hide();
                $('.matching-choice').hide();
                $('.matching-options').hide();
                $('.puzzle-choice').hide();
                $('.puzzle-options').hide();
                $('.cloze-choice').hide();
                $('.cloze-options').hide();
                $('#shuffleBox').hide();
                $('#preConditionQus').hide();
                <?php if(isModuleActive('AdvanceQuiz')): ?>
                $('#QuestionTypeLevel').removeClass('mt-25');
                <?php endif; ?>

            }

            if (type == "S") {
                $('#marks_required').hide();
            } else {
                $('#marks_required').show();
            }

        });
        $('#question-type').trigger('change')


        $(document).on("click", ".removeImage1", function (e) {
            e.preventDefault();
            let target = $(this).data('target')
            let id = $(this).data('id')
            console.log(id);
            $('#targetContent').val(target);
            $('#quizId').val(id);
            $('#removeImageModal').modal('show');
        });

        $(document).on("click", ".removeImageConfirm", function (e) {
            e.preventDefault();
            let target_name = $('#targetContent').val();
            let id = $('#quizId').val();
            let target = $(target_name);
            target.find('.filePlaceholder').val('');
            target.find('.fileUpload1').val('');
            $('#removeImageModal').modal('hide');
            $('.removeImage1').addClass('d-none');
            if (id != "") {


                var formData = {
                    id: id,
                };
                $.ajax({
                    type: "POST",
                    data: formData,
                    dataType: "json",
                    url: "<?php echo e(url('quiz/remove-image-ajax')); ?>",
                    success: function (data) {

                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            }
        });


        $(document).on("click", "#create-sorting-option", function (event) {
            $('#question_bank div.sorting-options').html('');

            var number_of_option = $('#number_of_sorting_option').val();
            for (var i = 0; i < number_of_option; i++) {
                var appendRow = '';
                appendRow += "<div class='row  mt-25' id='option-" + i + "'' data-id='" + i + "'>";
                appendRow += "<div class='col-lg-10 optionTitle'>";
                appendRow += "<div class='input-effect'>"
                appendRow += "<input class='primary_input_field name' type='text' name='sorting_option[]' autocomplete='off' required>";
                appendRow += "</div>";
                appendRow += "</div>";
                appendRow += "<div class='col-lg-2 mt-15 '>";

                appendRow += "            <span class='drag-handle' style='cursor: move;'>&#9776;</span>";

                appendRow += "</div>";
                appendRow += "</div>";

                $(".sorting-options").append(appendRow);
                console.log('here')

                getSortingOrders();

            }
        });


        function getSortingOrders() {
            $('.sorting-options').sortable({
                handle: ".drag-handle",
            });
        }

        getSortingOrders();
        // Cloze option
        $(document).on("click", "#create-cloze-option", function (event) {
            // Clear the options container before adding new rows
            $('.cloze-options').empty();

            // Get the number of rows from input
            var number_of_option = $('#number_of_cloze_option').val();

            // Initialize the table structure outside the loop
            var appendTable = '<table class="QA_table table table-borderless mt-3">';
            appendTable += '<thead>';
            appendTable += '<tr>';
            appendTable += '<th class="p-2"><?php echo e(trans("quiz.Number")); ?></th>';
            appendTable += '<th class="p-2 w-75"><?php echo e(trans("quiz.Options")); ?></th>';
            appendTable += '<th class="p-2"><?php echo e(trans("common.Action")); ?></th>';
            appendTable += '</tr>';
            appendTable += '</thead>';
            appendTable += '<tbody>'; // Start tbody

            // Generate rows based on the number_of_option input
            for (var i = 0; i < number_of_option; i++) {
                appendTable += generateOptionRow(i + 1);  // Generate each row
            }

            appendTable += '</tbody>'; // End tbody
            appendTable += '</table>';  // End table

            // Append the whole table at once
            $('.cloze-options').append(appendTable);

            console.log('Cloze options with multiple choices created');
        });

        // Function to generate a row with multiple options (default 4 options per row)
        function generateOptionRow(rowNumber) {
            var defaultOptions = 4;  // Default number of options per row
            var rowHTML = "<tr class='option-row'>";
            rowHTML += "<td class='p-2'>" + rowNumber + "</td>";
            rowHTML += "<td class='p-2'>";

            // Create a div that contains multiple options (default 4 options)
            rowHTML += "<div class='options-container' data-row-number='" + rowNumber + "'>";

            for (var i = 0; i < defaultOptions; i++) {
                rowHTML += generateOptionInput(rowNumber, i + 1);
            }

            rowHTML += "</div>";  // End options-container div
            rowHTML += "</td>";

            rowHTML += "<td class='p-2'>";
            rowHTML += "<div class='d-flex'><button type='button' class='primary-btn small fix-gr-bg add-option-btn'><i class='ti ti-plus m-0 p-0'></i></button>";
            rowHTML += "<button type='button' class='primary-btn small fix-gr-bg remove-option-btn ms-2'><i class='ti ti-trash  m-0 p-0'></i></button></div>";
            rowHTML += "</td>";
            rowHTML += "</tr>";

            return rowHTML;
        }

        // Function to generate an individual option input
        function generateOptionInput(rowNumber, optionNumber) {
            return "<div class='input-effect mb-2 d-flex align-items-center'>" +
                "<input class='primary_input_field name' placeholder='Option " + optionNumber + "' type='text' name='cloze_option[" + rowNumber + "][]' autocomplete='off' required>" +
                "<label class='primary_checkbox d-flex ms-3'>" +
                "<input name='cloze_answer[" + rowNumber + "]' value='" + optionNumber + "' type='radio'>" +
                "<span class='checkmark'></span>" +
                "</label>" +
                "</div>";
        }


        // Add new option input within a specific row
        $(document).on("click", ".add-option-btn", function () {
            // Get the parent row and number of current options in the row
            var optionsContainer = $(this).closest('tr').find('.options-container');
            var rowNumber = optionsContainer.data('row-number');
            var optionCount = optionsContainer.children().length;

            // Append a new option input to the current row
            optionsContainer.append(generateOptionInput(rowNumber, optionCount + 1));
        });

        // Remove the last option input within a specific row
        $(document).on("click", ".remove-option-btn", function () {
            var optionsContainer = $(this).closest('tr').find('.options-container');
            var optionCount = optionsContainer.children().length;

            // Ensure there's at least 1 option left in the row
            if (optionCount > 1) {
                optionsContainer.children().last().remove();
            } else {
                toastr.error("<?php echo e(__('quiz.At least one option is required')); ?>")
            }
        });


        // Generate puzzle question input fields
        $(document).on("click", "#create-puzzle-qus-option", function (event) {
            let qusItem = $('#puzzle_number_of_qus').val();
            let qusRow = '';

            // Translation strings for question
            let enterQuestion = "<?php echo e(trans('quiz.Enter Question')); ?>";

            for (let i = 0; i < qusItem; i++) {
                qusRow += "<div class='row optionType mb-3' data-type='qus' data-index='" + i + "'>";
                qusRow += "<div class='col-lg-12 optionTitle'>";
                qusRow += "<div class='input-group'>";
                qusRow += "<input class='form-control option_title' type='text' name='puzzle_qus[" + i + "]' placeholder='" + enterQuestion + " " + (i + 1) + "' required>";
                qusRow += "</div>";
                qusRow += "</div>";
                qusRow += "</div>";
            }

            $('#puzzleQus').html(qusRow);
            combineQusAndAns();
        });

        // Generate puzzle answer input fields
        $(document).on("click", "#create-puzzle-ans-option", function (event) {
            let ansItem = $('#puzzle_number_of_ans').val();
            let ansRow = '';

            // Translation strings for answer
            let enterAnswer = "<?php echo e(trans('quiz.Enter Answer')); ?>";

            for (let i = 0; i < ansItem; i++) {
                ansRow += "<div class='row optionType mb-3' data-type='ans' data-index='" + i + "'>";
                ansRow += "<div class='col-lg-12 optionTitle'>";
                ansRow += "<div class='input-group'>";
                ansRow += "<input class='form-control ans_title' type='text' name='puzzle_ans[" + i + "]' placeholder='" + enterAnswer + " " + (i + 1) + "'>";
                ansRow += "</div>";
                ansRow += "</div>";
                ansRow += "</div>";
            }

            $('#puzzleAns').html(ansRow);
            combineQusAndAns();
        });


        function combineQusAndAns() {
            let qusElements = $('#puzzleQus .optionType');
            let ansElements = $('#puzzleAns .optionType');
            let combineRow = `
                <div class="col-12">
                    <h4><?php echo e(__('quiz.Correct option')); ?></h4>
                </div>
            `;

            if (qusElements.length > 0 && ansElements.length > 0) {
                for (let i = 0; i < qusElements.length; i++) {
                    let qus = "<?php echo e(trans('quiz.Question')); ?> " + (i + 1) + " :";

                    combineRow += "<div class='row mb-5'>";
                    combineRow += "<div class='col-lg-6 '>";
                    combineRow += "<label> " + qus + "</label>";
                    combineRow += "</div>";
                    combineRow += "<div class='col-lg-6 d-flex flex-column gap-3'>";

                    // Create checkboxes for all available answers
                    for (let j = 0; j < ansElements.length; j++) {
                        let ans = "<?php echo e(__('quiz.Answer')); ?> " + (j + 1);

                        // Create unique IDs for each checkbox
                        let checkboxId = `questionReview_${i}_${j}`;

                        combineRow += "<label class='primary_checkbox d-flex text-nowrap mr-12'>";
                        combineRow += `<input name='question_review[${i}][${j}]' value='${j}' id='${checkboxId}' type='checkbox'>`;
                        combineRow += `<span class='checkmark'></span>`;
                        combineRow += `<span class='ms-2'>${ans}</span>`;
                        combineRow += "</label>";
                    }

                    combineRow += "</div>";
                    combineRow += "</div>";
                }
                $('#puzzleCombine').html(combineRow);
            }
        }


        $(document).on("change", ".option_title", function () {
            const index = $(this).closest('.optionType').data('index');
            const newValue = $(this).val();
            console.log(`Question ${index + 1} changed to: "${newValue}"`);
            // Add any additional logic you want to perform on change
        });

        // Handle change events for answer text inputs
        $(document).on("change", ".ans_title", function () {
            const index = $(this).closest('.optionType').data('index');
            const newValue = $(this).val();
            console.log(`Answer ${index + 1} changed to: "${newValue}"`);
            // Add any additional logic you want to perform on change
        });
    </script>
    <script src="<?php echo e(asset('/')); ?>/Modules/CourseSetting/Resources/assets/js/course.js"></script>


    <?php if ($__env->exists("quiz::partials._quiz_bank_script")) echo $__env->make("quiz::partials._quiz_bank_script", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/Modules/Quiz/Resources/views/question_bank.blade.php ENDPATH**/ ?>