<?php $__env->startSection('title'); ?>
    <?php echo e(Settings('site_title') ? Settings('site_title') : 'Infix LMS'); ?> | <?php echo e(_trans('installment.My Installments')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        .modal-dialog {
            max-width: 500px !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainContent'); ?>
    <div class="main_content_iner main_content_padding">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-3">
                <div class="dashboard_card text-center">
                    <div class="icon mx-auto">
                        <img src="<?php echo e(asset('Modules/Installment/Resources/assets/images/installment/1.png')); ?>" alt="">
                    </div>
                    <span><?php echo e(_trans('installment.Open Installment')); ?></span>
                    <h4>
                        <?php echo e(@$user_installment_overview['open']); ?>

                    </h4>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-3">
                <div class="dashboard_card text-center">
                    <div class="icon mx-auto">
                        <img src="<?php echo e(asset('Modules/Installment/Resources/assets/images/installment/2.png')); ?>" alt="">
                    </div>
                    <span><?php echo e(_trans('installment.Pending Verification')); ?></span>
                    <h4>
                        <?php echo e(@$user_installment_overview['pending_verification']); ?>

                    </h4>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-3">
                <div class="dashboard_card text-center">
                    <div class="icon mx-auto">
                        <img src="<?php echo e(asset('Modules/Installment/Resources/assets/images/installment/3.png')); ?>" alt="">
                    </div>
                    <span><?php echo e(_trans('installment.Finished Installments')); ?></span>
                    <h4>
                        <?php echo e(@$user_installment_overview['complete']); ?>

                    </h4>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-3">
                <div class="dashboard_card text-center">
                    <div class="icon mx-auto">
                        <img src="<?php echo e(asset('Modules/Installment/Resources/assets/images/installment/4.png')); ?>" alt="">
                    </div>
                    <span><?php echo e(_trans('installment.Overdue Installments')); ?></span>
                    <h4>
                        <?php echo e(@$user_installment_overview['overdue']); ?>

                    </h4>
                </div>
            </div>
        </div>
        <div class="dashboard_lg_card">
            <div class="container-fluid g-0">
                <div class="row">

                    <div class="col-12">
                        <div class="p-4">
                            <div class="row">
                                <div class="col-12">
                                    <div class="section__title3 mb_40">
                                        <h3 class="mb-0"><?php echo e(_trans('installment.Installment history')); ?></h3>
                                        <h4></h4>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="table-responsive">
                                        <table class="table custom_table3">
                                            <thead>
                                            <tr>
                                                <td colspan="4">

                                                </td>
                                                <td colspan="3" class="text-center">
                                                    <?php echo e(_trans('installment.Installment Overview')); ?>

                                                </td>
                                                <td></td>


                                            </tr>
                                            <tr>
                                                <td>
                                                    <?php echo e(_trans('common.SL')); ?>

                                                </td>
                                                <td width="30%">
                                                    <?php echo e(_trans('installment.Product')); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(_trans('installment.Purchase Date')); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(_trans('installment.Upfront')); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(_trans('installment.Total')); ?>

                                                </td>

                                                <td>
                                                    <?php echo e(_trans('installment.Remaining')); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(_trans('installment.Upcoming')); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(_trans('common.Action')); ?>

                                                </td>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $purchase_requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $purchase_request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php
                                                    $upfront_info = $purchase_request->installmentPayments->where('type', 'upfront')->first();
                                                    $InstallmentPurchaseController = new \Modules\Installment\Http\Controllers\InstallmentPurchaseController();
                                                    $installmentOverviewData = $InstallmentPurchaseController->installmentOverviewData($purchase_request->topic_id, $purchase_request->plan_id);
                                                    $installmentOverviewData = $installmentOverviewData['installment_overview'];

                                                    $unpaid_installments = $purchase_request->installmentPayments->where('status', '!=', 'paid');
                                                    $next_installment = $unpaid_installments->first();
                                                ?>
                                                <tr style="background-color:<?php echo e($next_installment ? ($next_installment->amount > 0 ? '#fff0d7;' :''):''); ?>">
                                                    <td class="text-center">
                                                        <?php echo e(@$loop->iteration); ?>

                                                    </td>
                                                    <td>
                                                        <a target="_blank"
                                                           href="<?php echo e(route('courseDetailsView', [$purchase_request->topic->slug])); ?>"><?php echo e(@$purchase_request->topic->title); ?></a>

                                                    </td>
                                                    <td>
                                                        <?php echo e(showDate(@$upfront_info->payment_date)); ?>


                                                    </td>
                                                    <td>
                                                        <?php echo e(getPriceFormat(@$upfront_info->amount)); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e(@$installmentOverviewData['total_installment_count'] . ' ' . _trans('installment.Parts')); ?>

                                                        <br>
                                                        <?php echo e('(' . @$installmentOverviewData['total_installment_amount'] . ')'); ?>

                                                    </td>


                                                    <td>
                                                        <?php if($unpaid_installments->count() > 0): ?>
                                                            <?php echo e(@$unpaid_installments->count() . ' ' . _trans('installment.Parts')); ?>

                                                            <br>
                                                            <?php echo e('(' . showPrice(@$unpaid_installments->sum('amount')) . ')'); ?>

                                                        <?php else: ?>
                                                            <?php echo e('-'); ?>

                                                        <?php endif; ?>

                                                    </td>
                                                    <td>
                                                        <?php if($next_installment): ?>
                                                            <?php echo e(showDate(@$next_installment->due_date)); ?> <br>
                                                            (<?php echo e(showPrice(@$next_installment->amount)); ?>)
                                                        <?php else: ?>
                                                            <?php echo e('-'); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(!in_array($purchase_request->payment_status, ['incomplete', 'paid'])): ?>
                                                            <a class="theme_btn small_btn3"
                                                               href="<?php echo e(route('installment.student_installment.purchase_request_details', $purchase_request->id)); ?>"><?php echo e(_trans('common.Details')); ?></a>
                                                        <?php else: ?>
                                                            <?php echo e(_trans('installment.Pending')); ?>

                                                        <?php endif; ?>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td class="text-center" colspan="7">
                                                        <?php echo e(__('common.No data available in the table')); ?>

                                                    </td>
                                                </tr>
                                            <?php endif; ?>

                                            </tbody>
                                        </table>
                                        <div class="mt-4">
                                            <?php echo e(@$purchase_requests->links()); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade admin-query admin_view_modal" id="messageModal">
        <div class="modal-dialog modal_1000px modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4> <?php echo e(_trans('gift.View Gift Message')); ?></h4>
                    <button type="button" class="close " data-bs-dismiss="modal">
                        <i class="ti-close "></i>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <div class="col-xl-12">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(theme('layouts.dashboard_master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/resources/views/frontend/infixlmstheme/pages/my-installments.blade.php ENDPATH**/ ?>