@extends('backend.master')
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="">
                        <div class="row">
                            <div class="col-lg-12 mt-4">
                                <div class="white_box_30px">
                                    <!-- SMTP form  -->
                                    <div class="main-title ">
                                        <h3 class="mb-3">{{ __('whatsapp.create_agent') }}</h3>
                                    </div>

                                    <form action="{{ route('whatsapp-support.agents.store') }}" method=POST
                                          enctype=multipart/form-data>
                                        @csrf
                                        <div class="row" id="pusher">
                                            <div class="col-xl-12 mb-4">
                                                <label class="primary_input_label mb-3">{{ __('common.Type') }}
                                                    <span class="required_mark">*</span></label>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" checked name="type" required
                                                               id="relationType1" value="1"
                                                               class="common-radio relationButton typeInput">
                                                        <label
                                                            for="relationType1">{{ __('whatsapp.Whatsapp') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="type" id="relationType2" value="2"
                                                               class="common-radio relationButton typeInput">
                                                        <label
                                                            for="relationType2">{{ __('whatsapp.Website URL') }}</label>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="col-xl-6 mb-4">
                                                <div class="primary_input ">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.name') }} <span
                                                            class="required_mark">*</span></label>
                                                    <input class="primary_input_field" name="name" type="text" required>
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4">
                                                <div class="primary_input ">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.designation') }}
                                                        <span class="required_mark">*</span></label>
                                                    <input class="primary_input_field" name="designation" type="text"
                                                           required>
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4 d-none" id="typeURL">
                                                <div class="primary_input ">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.URL') }}
                                                        <span class="required_mark">*</span></label>
                                                    <input class="primary_input_field" name="url" type="text"
                                                            >
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4" id="typeWhatsapp">
                                                <div class="primary_input ">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.number') }} <span
                                                            class="required_mark">*</span> (<small
                                                            class="text-danger">{{ __('whatsapp.with_country_code') }}</small>)</label>
                                                    <input class="primary_input_field phoneNumberInput" name="number"
                                                           type="text"
                                                           placeholder="{{ __('whatsapp.with_country_code') }}..">
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4">
                                                <div class="  ">
                                                    <x-upload-file
                                                        name="avatar"
                                                        type="image"
                                                        label="{{ __('whatsapp.avatar') }}"
                                                    />

                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4">
                                                <label class="primary_input_label mb-3">{{ __('whatsapp.status') }}
                                                    <span class="required_mark">*</span></label>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" checked name="status" required
                                                               id="relationFather3" value="1"
                                                               class="common-radio relationButton">
                                                        <label
                                                            for="relationFather3">{{ __('whatsapp.active') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="status" id="relationMother4" value="0"
                                                               class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4">{{ __('whatsapp.inactive') }}</label>
                                                    </div>
                                                    @error('status') <small
                                                        class="text-danger font-italic"><span
                                                            class="required_mark">*</span>{{ $message }}
                                                    </small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4">
                                                <label
                                                    class="primary_input_label mb-3">{{ __('whatsapp.always_available') }}
                                                    <span class="required_mark">*</span></label>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="always_available" required
                                                               id="relationFather33333" value="1"
                                                               class="common-radio relationButton" checked>
                                                        <label
                                                            for="relationFather33333">{{ __('whatsapp.yes') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="always_available"
                                                               id="relationMother4433" value="0"
                                                               class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4433">{{ __('whatsapp.no') }}</label>
                                                    </div>
                                                    @error('always_available') <small
                                                        class="text-danger font-italic"><span
                                                            class="required_mark">*</span>{{ $message }}
                                                    </small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <h4>{{__('whatsapp.time')}} : </h4>
                                                @foreach(\Carbon\Carbon::getDays() as $index => $day)
                                                    <div class="row g-0  input-right-icon mt-3">
                                                        <div class="col-md-3 mb-4">

                                                            <div class="input-effect">
                                                                <input type="checkbox" id="isBreak{{ $index }}"
                                                                       class="common-checkbox read-only-input"
                                                                       value="{{$day}}" name="day[]">
                                                                <label for="isBreak{{ $index }}">{{ $day }}</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3 mb-4">

                                                            <div class="col me-2">
                                                                <div class="input-effect">
                                                                    <label
                                                                        class="mb-2">{{__("whatsapp.Start Time")}}</label>
                                                                    <input id="agent_start{{$index}}"
                                                                           class="primary-input primary-input-field  time form-control has-content"
                                                                           type="text" name="start[]">
                                                                </div>
                                                            </div>
                                                            {{--                                                            <div class="col-auto">--}}
                                                            {{--                                                                <button class="" type="button">--}}
                                                            {{--                                                                    <i class="ti-timer"></i>--}}
                                                            {{--                                                                </button>--}}
                                                            {{--                                                            </div>--}}
                                                        </div>
                                                        <div class="col-md-3 mb-4">

                                                            <div class="col">
                                                                <div class="input-effect">
                                                                    <label
                                                                        class="mb-2">{{__('whatsapp.End Time')}}</label>
                                                                    <input id="agent_end{{$index}}"
                                                                           class=" primary-input  primary-input-field time form-control has-content"
                                                                           type="text" name="end[]">
                                                                </div>
                                                            </div>
                                                            {{--                                                            <div class="col-auto">--}}
                                                            {{--                                                                <button class="" type="button">--}}
                                                            {{--                                                                    <i class="ti-timer"></i>--}}
                                                            {{--                                                                </button>--}}
                                                            {{--                                                            </div>--}}
                                                        </div>
                                                        <div class="col-md-3 mb-4">

                                                            @if($index == 0)
                                                                <p onclick="setTimeToAll()"
                                                                   class="primary-btn radius_30px fix-gr-bg ms-3 w-fit">{{__('whatsapp.Apply All Days')}}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-center align-content-center">
                                            <button type="submit"
                                                    class="primary-btn fix-gr-bg">
                                                <i class="ti-check"></i> {{ __('common.Save') }}
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script type="application/javascript">

{{-- docment ready--}}
        $(document).ready(function () {
            $(document).on('click', '.typeInput', function () {
                let whatsappType=$('#typeWhatsapp');
                let urlType=$('#typeURL');

                 if ($(this).val() == 1) {
                     whatsappType.removeClass('d-none');
                     urlType.addClass('d-none');
                 }else{

                     whatsappType.addClass('d-none');
                     urlType.removeClass('d-none');
                 }
            })
        })
    </script>
@endpush
