<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPrebookingAmountToCartsTable extends Migration
{

    public function up()
    {

        Schema::table('carts', function (Blueprint $table) {
            if (!Schema::hasColumn("carts", 'pre_booking_amount')) {
                $table->float('pre_booking_amount')->default(0);
            }
        });

        Schema::table('checkouts', function (Blueprint $table) {
            if (!Schema::hasColumn("checkouts", 'pre_booking_amount')) {
                $table->float('pre_booking_amount')->default(0);
            }
        });
    }

    public function down()
    {
        Schema::table('carts', function (Blueprint $table) {
            if (Schema::hasColumn("carts", 'pre_booking_amount')) {
                $table->dropColumn('pre_booking_amount');
            }
        });

        Schema::table('checkouts', function (Blueprint $table) {
            if (Schema::hasColumn("checkouts", 'pre_booking_amount')) {
                $table->dropColumn('pre_booking_amount');
            }
        });
    }
}
