@extends('backend.master')
@php
    $table_name='surveys';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}


    <div class="row">
        <div class="col-lg-12">
            <div class="white-box mb-30">
                <form method="GET" action="" class="form-horizontal" id="search_group">
                    <div class="row">

                        <div class="col-lg-4 mt-30-md md_mb_20">
                            <label class="primary_input_label"
                                   for="">  {{__('survey.Survey Type')}}</label>
                            <select
                                {{ $errors->has('survey_type') ? ' autofocus' : '' }}
                                class="primary_select{{ $errors->has('survey_type') ? ' is-invalid' : '' }}"
                                name="survey_type" id="survey_type">
                                <option
                                    value="1" {{request('survey_type')=='1'?'selected':''}}> {{__('survey.Course survey')}}</option>
                                <option
                                    value="2" {{request('survey_type')=='2'?'selected':''}}> {{__('survey.Independence')}}</option>
                            </select>

                        </div>

                        <div class="col-lg-4 mt-30-md md_mb_20">
                            <label class="primary_input_label" for="category_id">{{__('common.Category')}}</label>
                            <select class="primary_select "
                                    id="category" name="category">
                                <option data-display=" {{__('common.Select')}}" value=""> {{__('common.Category')}}
                                </option>
                                @foreach($categories as $category)
                                    @if($category->parent_id==0)
                                        @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                    @endif
                                @endforeach
                            </select>

                        </div>


                        <div class="col-lg-12 mt-3  ">
                            <label class="primary_input_label" for=""></label>
                            <button type="submit" class="primary-btn  fix-gr-bg">
                                <span class="ti-search pe-2"></span>
                                {{__('quiz.Search')}}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">

                    <div class="col-lg-12">

                        <div class="main-title d-flex justify-content-between">
                            <div>
                                <h3 class="mb-20" id="page_title">{{__('survey.Survey') }} {{__('common.List')}}</h3>

                            </div>
                            <div class="ps-3">
                                @if (permissionCheck('survey.survey_store'))
                                    <a class="primary-btn radius_30px fix-gr-bg"
                                       href="{{route('survey.survey_add')}}">
                                        <i class="ti-plus"></i>{{__('common.Add')}}
                                    </a>
                                @endif
                            </div>
                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{__('common.SL')}}</th>
                                            <th scope="col">{{__('common.Name')}}</th>
                                            <th scope="col">{{ __('common.Type') }}</th>
                                            <th scope="col">{{ __('courses.Course') }}</th>
                                            @if(isModuleActive('Org'))
                                                <th scope="col">{{ __('survey.Created By') }}</th>
                                                <th scope="col">{{ __('org.Org Chart') }}</th>
                                                <th scope="col">{{ __('org.Job Position') }}</th>
                                            @endif
                                            <th scope="col">{{__('survey.Participants')}}</th>
                                            <th scope="col">{{__('common.Published')}}</th>
                                            <th scope="col">{{__('common.Status')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($surveys as $index => $survey)
                                            <tr>
                                                <td scope="col">{{ translatedNumber($index+1) }}</td>
                                                <td scope="col">{{ $survey->title }}</td>
                                                <td scope="col">{{ $survey->survey_type==1?trans('survey.Course Survey'):trans('survey.Independence') }}</td>
                                                <td scope="col">{{ $survey->course->title }}</td>
                                                @if(isModuleActive('Org'))
                                                    <td scope="col">{{ $survey->user->name }}</td>
                                                    <td scope="col">
                                                        @if($survey->audience==1)
                                                            {{trans('blog.Public')}}
                                                        @else

                                                            <a type="button"
                                                               class="primary-btn radius_30px fix-gr-bg text-white  btn-modal"
                                                               data-container="#commonModal"
                                                               href="{{routeIsExist('org.branch.survey')?route('org.branch.survey',$survey->id):''}}">
                                                                {{trans('blog.Specify')}}
                                                            </a>
                                                        @endif
                                                    </td>
                                                    <td scope="col">
                                                        @if($survey->position_audience==1)
                                                            {{trans('common.All')}}
                                                        @else
                                                            <a type="button"
                                                               class="primary-btn radius_30px fix-gr-bg text-white  btn-modal"
                                                               data-container="#commonModal"
                                                               href="{{routeIsExist('org.position.survey')?route('org.position.survey',$survey->id):''}}">
                                                                {{trans('blog.Specify')}}
                                                            </a>
                                                        @endif
                                                    </td>
                                                @endif
                                                <td scope="col">{{ translatedNumber($survey->participants->count()) }}</td>
                                                <td> {{$survey->isPublish}}</td>
                                                <td class="nowrap">
                                                    @if (permissionCheck('survey.change_status'))
                                                        <label class="switch_toggle ml-20" for="status{{$survey->id}}">
                                                            <input type="checkbox" class="status_enable_disable"
                                                                   name="status" id="status{{$survey->id}}"
                                                                   {{$survey->status==1? 'checked':''}}  value="{{$survey->id}}">
                                                            <i class="slider round"></i>
                                                        </label>
                                                    @else
                                                        @if ($survey->status==1)
                                                            Enabled
                                                        @else
                                                            Disabled

                                                        @endif
                                                    @endif

                                                </td>

                                                <td scope="col">
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{__('common.Action')}}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2" style="">
                                                            @if (permissionCheck('survey.survey_update'))
                                                                <a href="{{ route('survey.survey_edit', $survey->id) }}"
                                                                   class="dropdown-item editStudent"
                                                                   type="button">{{__('common.Edit')}}</a>
                                                            @endif
                                                            @if($survey->participants->count()==0)
                                                                @if (permissionCheck('survey.survey_delete'))
                                                                    <a onclick="confirm_modal('{{route('survey.survey_delete', $survey->id)}}');"
                                                                       class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                                @endif
                                                            @endif
                                                            @if (permissionCheck('survey.question_assign'))
                                                                <a href="{{ route('survey.question_assign', $survey->id) }}"
                                                                   class="dropdown-item editStudent" type="button">Set
                                                                    Question</a>

                                                            @endif
                                                            @if (permissionCheck('survey.survey_participants'))

                                                                <a href="{{ route('survey.survey_participants', $survey->id) }}"
                                                                   class="dropdown-item editStudent"
                                                                   type="button">{{__('survey.Participants')}}</a>
                                                            @endif
                                                            @if (permissionCheck('survey.user_based_report'))
                                                                <a href="{{ route('survey.user_based_report', $survey->id) }}"
                                                                   class="dropdown-item editStudent" type="button">User
                                                                    based report</a>

                                                            @endif
                                                            @if (permissionCheck('survey.question_based_report'))
                                                                <a href="{{ route('survey.question_based_report', $survey->id) }}"
                                                                   class="dropdown-item editStudent" type="button">Question
                                                                    based report</a>

                                                            @endif
                                                            @if (permissionCheck('survey.question_based_graph'))
                                                                <a href="{{ route('survey.question_based_graph', $survey->id) }}"
                                                                   class="dropdown-item editStudent"
                                                                   type="button">Graph</a>

                                                            @endif


                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>
@endpush

