(function ($) {
    "use strict";

    $(document).ready(function () {
        $('#set_time_div').hide();
        $("#select_role").on("change", function () {
            var url = $("#url").val();

            var formData = {
                id: $(this).val(),
            };
            $.ajax({
                type: "GET",
                data: formData,
                dataType: "json",
                url: url + "/" + "homework/ajaxGetUserListFronRoleId",
                success: function (data) {
                    var a = "";
                    $.each(data, function (i, item) {
                        if (item.length) {
                            $("#user_id").find("option").not(":first").remove();
                            $("#userDiv ul").find("li").not(":first").remove();

                            $.each(item, function (i, section) {
                                $("#user_id").append(
                                    $("<option>", {
                                        value: section.id,
                                        text: section.name,
                                    })
                                );

                                $("#userDiv ul").append(
                                    "<li data-value='" +
                                    section.id +
                                    "' class='option'>" +
                                    section.name +
                                    "</li>"
                                );
                            });
                        } else {
                            $("#userDiv .current").html("Select User");
                            $("#user_id").find("option").not(":first").remove();
                            $("#userDiv ul").find("li").not(":first").remove();
                        }
                    });
                    // console.log(a);
                },
                error: function (data) {
                    console.log("Error:", data);
                },
            });
        });
        $("#select_course").on("change", function () {
            var url = $("#url").val();

            var formData = {
                id: $(this).val(),
            };
            $.ajax({
                type: "GET",
                data: formData,
                dataType: "json",
                url: url + "/" + "homework/ajaxChapterListFromCourseId",
                success: function (data) {
                    var a = "";
                    $.each(data, function (i, item) {
                        if (item.length) {
                            $("#chapter_id").find("option").not(":first").remove();
                            $("#chapter_div ul").find("li").not(":first").remove();

                            $.each(item, function (i, section) {
                                $("#chapter_id").append(
                                    $("<option>", {
                                        value: section.id,
                                        text: section.name,
                                    })
                                );

                                $("#chapter_div ul").append(
                                    "<li data-value='" +
                                    section.id +
                                    "' class='option'>" +
                                    section.name +
                                    "</li>"
                                );
                            });
                        } else {
                            $("#chapter_div .current").html("Select Chapter");
                            $("#chapter_id").find("option").not(":first").remove();
                            $("#chapter_div ul").find("li").not(":first").remove();
                        }
                    });
                    // console.log(a);
                },
                error: function (data) {
                    console.log("Error:", data);
                },
            });
        });
        $(".select_answer_type").on("change", function () {
            var url = $("#url").val();
            var un_id = $(this).attr('data-id');
            console.log(un_id);
            var formData = {
                type: $(this).val(),
            };
            if ($(this).val() == 'textarea') {
                $('#answer_set_div_' + un_id).hide();
            } else {
                $('#answer_set_div_' + un_id).show();
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "survey/ajaxAnswerSetFromAnswerType",
                    success: function (data) {
                        var a = "";
                        $.each(data, function (i, item) {
                            if (item.length) {
                                $("#select_answer_set_" + un_id).find("option").not(":first").remove();
                                $("#answer_set_div_" + un_id + " ul").find("li").not(":first").remove();

                                $.each(item, function (i, section) {
                                    $("#select_answer_set_" + un_id).append(
                                        $("<option>", {
                                            value: section.id,
                                            text: section.name,
                                        })
                                    );

                                    $("#answer_set_div_" + un_id + " ul").append(
                                        "<li data-value='" +
                                        section.id +
                                        "' class='option'>" +
                                        section.name +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#answer_set_div_" + un_id + " .current").html("Select Set");
                                $("#select_answer_set_" + un_id).find("option").not(":first").remove();
                                $("#answer_set_div_" + un_id + " ul").find("li").not(":first").remove();
                            }
                        });
                        // console.log(a);
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            }
        });
        $("#SurveyStaffsByRole").on("change", function () {
            $("#checkbox").prop("checked", false);
            var url = $("#url").val();
            console.log($(this).val());

            var formData = {
                id: $(this).val(),
            };

            $.ajax({
                type: "GET",
                data: formData,
                dataType: "json",
                url: url + "/" + "survey/studStaffByRole",
                success: function (data) {
                    var a = "";


                    $("#user_section #userInput").empty();
                    $("#user_section .infix_ul_lists li").empty();

                    $.each(data, function (key, value) {
                        $.each(value, function (i, staffs) {
                            $("#user_section #userInput").append(
                                $("<option>", {
                                    value: staffs.id,
                                    text: staffs.name,
                                })
                            );

                            $("#user_section .infix_ul_lists").append(' <li data-search-term="' + staffs.name + '">\n' +
                                '                        <label for="ms-opt-user-' + staffs.id + '">\n' +
                                '                            <span class="checkmark"></span>\n' +
                                '                            <input  type="checkbox" title="' + staffs.name + '" id="ms-opt-user-' + staffs.id + '" value="' + staffs.id + '"">' + staffs.name + '</label></li>');


                        });
                    });


                },
                error: function (data) {
                    console.log("Error:", data);
                },
            });
            $('select[multiple]').multiselect('reset');


        });

        $(document).on("click", "#add_new_question", function (e) {

            e.preventDefault();
            let table_body = $('#question_table tbody');
            let counter = $('#counter').val();
            let counter_val = parseInt(counter) + 1;
            $('#counter').val(counter_val);
            console.log(counter_val);
            let markup = `
            <tr id="row_${counter_val}">
                <td>
                   ${counter_val}
                </td>
                <td>
                <input name="title[${counter_val}]" id="title" class="primary_input_field name " placeholder="Question Title" type="text">
                </td>
                <td>
                <select class="primary_select mb-25   select_answer_type" onChange="getSetList('dom_${counter_val}')" id="dom_${counter_val}" name="answer_type[${counter_val}]" data-id="dom_${counter_val}" style="display: none;">
                    <option selected value="">Answer Type</option>
                    <option  value="Checkbox">Checkbox</option>
                    <option value="dropdown">Dropdown</option>
                    <option value="radio">Radio</option>
                    <option value="textarea">Textarea</option>
                </select>
                <div class="nice-select primary_select mb-25 select_answer_type" tabindex="0"><span class="current">Answer Type</span><div class="nice-select-search-box"><input type="text" class="nice-select-search" placeholder="Search..."></div><ul class="list"><li data-value="" class="option">Answer Type</li><li data-value="Checkbox" class="option selected">Checkbox</li><li data-value="dropdown" class="option">Dropdown</li><li data-value="radio" class="option">Radio</li><li data-value="textarea" class="option">Textarea</li></ul></div> </td>
                <td>
                <div class="" id="answer_set_div_dom_${counter_val}">
                <select class="primary_select mb-25  " name="answer_set[${counter_val}]" id="select_answer_set_dom_${counter_val}" style="display: none;">
                    <option value="">Answer Set</option>
                </select>
                <div class="nice-select primary_select mb-25" tabindex="0"><span class="current">Answer Set</span><div class="nice-select-search-box"><input type="text" class="nice-select-search" placeholder="Search..."></div><ul class="list"><li data-value="" class="option selected">Answer Set</li></ul></div> </div>
                </td>
                <td>
                <span class="primary-btn icon-only fix-gr-bg"  data-row_id="row_${counter_val}" onclick="deleteSurveyQuestion(${counter_val})">
                                                        <i class="ti-trash"></i></span>
                </td>
            </tr>
            `;
            table_body.append(markup)


        });


    });

    function deleteSurveyQuestion(row_id) {
        let row = $('#row_' + row_id);
        row.remove();
    }

    function getSetList(id) {
        let un_id = id;
        let selected_val = $('#' + id).val();
        let dom_url = $('#dom_url').val();
        console.log(selected_val);
        if (selected_val == 'textarea') {
            $('#answer_set_div_' + un_id).hide();
        } else {
            $('#answer_set_div_' + un_id).show();
            var formData = {
                type: selected_val,
            };
            $.ajax({
                type: "GET",
                data: '',
                dataType: "json",
                url: dom_url + "/" + "survey/ajaxAnswerSetFromAnswerType?type=" + selected_val,
                success: function (data) {
                    var a = "";
                    $.each(data, function (i, item) {
                        if (item.length) {
                            $("#select_answer_set_" + un_id).find("option").not(":first").remove();
                            $("#answer_set_div_" + un_id + " ul").find("li").not(":first").remove();

                            $.each(item, function (i, section) {
                                $("#select_answer_set_" + un_id).append(
                                    $("<option>", {
                                        value: section.id,
                                        text: section.name,
                                    })
                                );

                                $("#answer_set_div_" + un_id + " ul").append(
                                    "<li data-value='" +
                                    section.id +
                                    "' class='option'>" +
                                    section.name +
                                    "</li>"
                                );
                            });
                        } else {
                            $("#answer_set_div_" + un_id + " .current").html("Select Set");
                            $("#select_answer_set_" + un_id).find("option").not(":first").remove();
                            $("#answer_set_div_" + un_id + " ul").find("li").not(":first").remove();
                        }
                    });
                    // console.log(a);
                },
                error: function (data) {
                    console.log("Error:", data);
                },
            });
        }
    }

    function setTimeForSurvey() {
        let set_time_checkbox = $('#set_time_checkbox');
        let set_time_div = $('#set_time_div');
        set_time_checkbox.change(function () {
            if (set_time_checkbox.is(':checked')) {
                set_time_div.attr('class', 'row d-flex');
            } else {
                set_time_div.attr('class', 'row');
            }
        });

    }


    let available_for_div = $('#available_for_div');


    let privacy_set = $('#privacy_set');
    let privacy_text = $('#show_privacy');
    privacy_set.change(function () {
        if (privacy_set.is(':checked')) {
            privacy_text.text('Yes');

        } else {
            privacy_text.text('No')
            available_for_div.show();

        }

        $('select[multiple]').multiselect('reset');


    });

})(jQuery);
