<?php

namespace Modules\Survey\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Survey\Entities\SurveyQuestion;

class SurveyQuestionController extends Controller
{
    public function index()
    {
        return view('survey::index');
    }

    public function create()
    {
        return view('survey::create');
    }


    public function store(Request $request)
    {


        $rules = [
            'title.*' => 'required',
            'answer_type.*' => 'required',
        ];

        $request->validate($rules, validationMessage($rules));
        try {
            foreach ($request->answer_type as $key => $value) {
                if ($value != 'textarea') {
                    if ($request->answer_set[$key] == null) {
                        Toastr::error(trans('frontend.Answer Set not selected'), trans('common.Failed'));
                        return redirect()->back();
                    }
                }
            }
            $questions = SurveyQuestion::where('survey_id', $request->survey_id)->delete();

            foreach ($request->title as $key => $question) {
                $survey_question = new SurveyQuestion();
                $survey_question->survey_id = $request->survey_id;
                $survey_question->title = $question;
                $survey_question->answer_type = $request->answer_type[$key];
                if ($request->answer_set[$key] != 0) {
                    $survey_question->answer_set = $request->answer_set[$key];
                } else {
                    $survey_question->answer_set = null;
                }


                $survey_question->save();
            }

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function show($id)
    {
        return view('survey::show');
    }


    public function edit($id)
    {
        return view('survey::edit');
    }




}
