<?php

namespace Modules\Survey\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Category;
use Modules\Setting\Entities\UsedMedia;

class SurveyQuestionBank extends Model
{
    protected $guarded = ['id'];

    public function group()
    {
        return $this->belongsTo(SurveyGroup::class, 'group_id')->withDefault();
    }

    public function category()
    {

        return $this->belongsTo(Category::class, 'category_id', 'id')->withDefault();
    }

    public function subCategory()
    {

        return $this->belongsTo(Category::class, 'sub_category_id', 'id')->withDefault();
    }

    public function questionMuRand()
    {
        return $this->hasMany(SurveyQuestionBankMuOption::class, 'survey_question_bank_id', 'id')->inRandomOrder();
    }

    public function questionMu()
    {
        return $this->hasMany(SurveyQuestionBankMuOption::class, 'survey_question_bank_id', 'id');
    }

    public function image_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'image');
    }

}
