<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\SystemSetting\Entities\EmailTemplate;

class AddEmailTampleteForSupportTicket extends Migration
{

    public function up()
    {
        $template = EmailTemplate::where('act', 'CREATE_SUPPORT_TICKET')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'CREATE_SUPPORT_TICKET';
        }
        $shortCode = '{"subject":"Subject","created_by":"Created By","time":"Time","category":"Category","priority":"Priority","message":"Message"}';
        $subject = 'New Support Ticket Created';
        $br = "<br/>";
        $body = "Subject: {{subject}} " . $br . "Created By: {{created_by}} " . $br . "Time: {{time}}," . "Priority: {{priority}}," . $br . "Category: {{category}}" . $br . "Message: {{message}}" . "{{footer}}";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();


        $template = EmailTemplate::where('act', 'ASSIGN_SUPPORT_TICKET')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'ASSIGN_SUPPORT_TICKET';
        }
        $shortCode = '{"subject":"Subject","assign_by":"Assign By","time":"Time","ticket_no":"Ticket no","priority":"Priority","category":"Category"}';
        $subject = 'Support Ticket Assign To You';
        $br = "<br/>";
        $body = "Subject: {{subject}} " . $br . "Assign By: {{assign_by}} " . $br . "Time: {{time}}," . $br . "Ticket no: {{ticket_no}},"  . $br . "Priority: {{priority}}," . $br . "Category: {{category}}" . "{{footer}}";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;
        $template->email_body = htmlPart($subject, $body);
        $template->save();


        $template = EmailTemplate::where('act', 'REPLY_SUPPORT_TICKET')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'REPLY_SUPPORT_TICKET';
        }
        $shortCode = '{"subject":"Subject","replied_by":"Replied By","time":"Time","ticket_no":"Ticket no","priority":"Priority","category":"Category","status":"Status","message":"Message"}';
        $subject = 'New Reply On Support Ticket';
        $br = "<br/>";
        $body = "Subject: {{subject}} " . $br . "Replied By: {{replied_by}} " . $br . "Time: {{time}}," . $br . "Ticket no: {{ticket_no}}," . $br . "Priority: {{priority}}," . $br . "Status: {{status}}," . $br . "Category: {{category}}" . $br . "Message: {{message}}" . "{{footer}}";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;
        $template->email_body = htmlPart($subject, $body);
        $template->save();
    }


    public function down()
    {
        //
    }
}
