<?php


Route::prefix('subscription')->middleware('auth')->group(function () {


    Route::get('/executeCommand', 'SettingController@executeCommand')->name('subscription.executeCommand')->middleware('RoutePermissionCheck:subscription.executeCommand');

    Route::get('/faq', 'FaqController@index')->name('subscription.faq.index')->middleware('RoutePermissionCheck:subscription.faq.index');
    Route::post('/faq-store', 'FaqController@store')->name('subscription.faq.store')->middleware('RoutePermissionCheck:subscription.faq.store');
    Route::post('/faq-update', 'FaqController@update')->name('subscription.faq.update')->middleware('RoutePermissionCheck:subscription.faq.update');
    Route::post('/faq-delete', 'FaqController@destroy')->name('subscription.faq.destroy')->middleware('RoutePermissionCheck:subscription.faq.destroy');

    Route::get('/plan', 'SubscriptionController@index')->name('subscription.plan.index')->middleware('RoutePermissionCheck:subscription.plan.index');
    Route::post('/plan-store', 'SubscriptionController@store')->name('subscription.plan.store')->middleware('RoutePermissionCheck:subscription.plan.store');
    Route::post('/plan-update', 'SubscriptionController@update')->name('subscription.plan.update')->middleware('RoutePermissionCheck:subscription.plan.update');
    Route::post('/plan-delete', 'SubscriptionController@destroy')->name('subscription.plan.destroy')->middleware('RoutePermissionCheck:subscription.plan.destroy');


    Route::get('/planFeature', 'PlanFeatureController@index')->name('subscription.planFeature.index')->middleware('RoutePermissionCheck:subscription.planFeature.index');
    Route::post('/planFeature-store', 'PlanFeatureController@store')->name('subscription.planFeature.store')->middleware('RoutePermissionCheck:subscription.planFeature.store');
    Route::post('/planFeature-update', 'PlanFeatureController@update')->name('subscription.planFeature.update')->middleware('RoutePermissionCheck:subscription.planFeature.update');
    Route::post('/planFeature-delete', 'PlanFeatureController@destroy')->name('subscription.planFeature.destroy')->middleware('RoutePermissionCheck:subscription.planFeature.destroy');


    Route::get('/setting', 'SettingController@index')->name('subscription.setting.index')->middleware('RoutePermissionCheck:subscription.setting.index');
    Route::post('/setting-store', 'SettingController@store')->name('subscription.setting.store')->middleware('RoutePermissionCheck:subscription.setting.store');

    Route::post('/change-plan-feature-position', 'PlanFeatureController@changePlanFeaturePosition')->name('changePlanFeaturePosition')->middleware('RoutePermissionCheck:changePlanFeaturePosition');
    Route::post('/change-plan-position', 'SubscriptionController@changePlanPosition')->name('changePlanPosition')->middleware('RoutePermissionCheck:changePlanPosition');
    Route::post('/change-faq-position', 'FaqController@changeFaqPosition')->name('changeFaqPosition')->middleware('RoutePermissionCheck:changeFaqPosition');
    Route::post('/change-plan-popular', 'SubscriptionController@changePlanPopular')->name('changePlanPopular')->middleware('auth');

    Route::get('/add-course-plan', 'AssignCourseController@index')->name('assignCourseToPlan')->middleware('RoutePermissionCheck:assignCourseToPlan');
    Route::get('/subscription-course-reordering', 'AssignCourseController@reordering')->name('subscription.course.reordering')->middleware('RoutePermissionCheck:assignCourseToPlan');
    Route::post('/subscription-course-delete', 'AssignCourseController@delete')->name('subscription.course.delete')->middleware('RoutePermissionCheck:assignCourseToPlan');
    Route::post('/subscription-course-add', 'AssignCourseController@add')->name('subscription.course.add-element')->middleware('RoutePermissionCheck:assignCourseToPlan');
    Route::post('/subscription-plan-add-to-card', 'CourseSubscriptionController@planAddToCart')->name('subscription.planAddToCart');


    Route::get('/enroll-list', 'EnrollListController@index')->name('subscription.enroll-list')->middleware('RoutePermissionCheck:subscription.enroll-list');
    Route::get('/enroll-list-data', 'EnrollListController@data')->name('subscription.enroll-list-data')->middleware('RoutePermissionCheck:subscription.enroll-list');

});
