<?php

namespace Modules\Subscription\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\CourseSetting\Entities\Category;
use Modules\Subscription\Entities\CourseSubscription;
use Modules\Subscription\Entities\SubscriptionSetting;

class SubscriptionController extends Controller
{

    public function index()
    {
        try {
            $plans = CourseSubscription::orderBy('order', 'asc')->get();
            $setting = SubscriptionSetting::getData();
            $categories = Category::with('parent','childs')->where('status', 1)
                ->whereNull('parent_id')
                ->orderBy('position_order')->get();
            return view('subscription::plan.index', compact('plans', 'setting', 'categories'));

        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();

        }
    }


    public function store(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $request->validate([
            'title' => 'required|unique:course_subscriptions,title',
            'price' => 'required',
            'btn_txt' => 'required'
        ]);

        try {
            $total = CourseSubscription::latest()->count();
            $plan = new CourseSubscription();
            $plan->title = $request->title;
            $plan->price = $request->price;
            $plan->category_id = (int)$request->category;
            $plan->btn_txt = $request->btn_txt;
            $plan->about = $request->about;
            $plan->days = $request->days;
            $plan->is_recurring = $request->is_recurring;
            $plan->order = $total + 1;
            $plan->save();

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();

        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));

            return redirect()->back();
        }
    }

    public function update(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $request->validate([
            'title' => 'required|unique:course_subscriptions,title,' . $request->id,
            'price' => 'required',
            'btn_txt' => 'required'
        ]);

        try {
            $plan = CourseSubscription::findOrFail($request->id);
            $plan->title = $request->title;
            $plan->category_id = (int)$request->category;
            $plan->price = $request->price;
            $plan->btn_txt = $request->btn_txt;
            $plan->about = $request->about;
            $plan->days = $request->days;
            $plan->order = $request->order;
            $plan->is_recurring = $request->is_recurring;
            $plan->save();

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {
            $id = $request->id;
            $item = CourseSubscription::findOrFail($id);
            $item->delete();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();

        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function changePlanPosition(Request $request)
    {
        if (demoCheck()) {
            return false;
        }
        $ids = $request->get('ids');

        if (count($ids) != 0) {
            foreach ($ids as $key => $id) {

                $chapter = CourseSubscription::find($id);
                if ($chapter) {
                    $chapter->order = $key + 1;
                    $chapter->save();
                }

            }
        }

        return true;
    }

    public function changePlanPopular(Request $request)
    {
        if (demoCheck()) {
            return false;
        }
        $plan = CourseSubscription::find($request->id);
        if ($plan) {
            $plan->popular = $request->status == 1 ? 0 : 1;
            $plan->save();
        }

        return true;
    }
}
