<?php

namespace Modules\Subscription\Http\Controllers;

use Illuminate\Routing\Controller;
use Modules\Subscription\Entities\SubscriptionCheckout;
use Yajra\DataTables\Facades\DataTables;

class EnrollListController extends Controller
{

    public function index()
    {
        return view('subscription::enroll.index');
    }

    public function data()
    {

        $query = SubscriptionCheckout::with('user', 'plan');


        return Datatables::of($query)
            ->addIndexColumn()
            ->addColumn('user.image', function ($query) {
                return " <div class=\"profile_info\"><img src='" . getProfileImage($query->user->image, $query->user->name) . "'></div>";
            })
            ->editColumn('user.name', function ($query) {
                return $query->user->name;
            })
            ->editColumn('user.email', function ($query) {
                return $query->user->email;

            })->editColumn('days', function ($query) {
                return translatedNumber($query->days) . ' ' . trans('common.Days');

            })->editColumn('price', function ($query) {
                return getPriceFormat($query->price);

            })->editColumn('start_date', function ($query) {
                return showDate($query->start_date);

            })->editColumn('end_date', function ($query) {
                return showDate($query->end_date);

            })
            ->rawColumns(['user.image'])->make(true);
    }
}
