<?php

namespace Modules\Subscription\Http\Controllers;


use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\CourseSetting\Entities\Course;
use Modules\Subscription\Entities\CourseSubscription;
use Modules\Subscription\Entities\SubscriptionCourseList;

class AssignCourseController extends Controller
{

    public function index(Request $request)
    {
        if (!isset($request->id)) {
            Toastr::error(trans('frontend.Invalid Request'), trans('common.Failed'));
            return redirect()->route('subscription.plan.index');
        }
        $id = $request->id;
        $plan = CourseSubscription::findOrFail($id);
        $courses = Course::query()
            ->when($plan->category_id > 0, function ($q) use ($plan) {
                return $q->where('category_id', $plan->category_id);
            })
            ->where('type', 1)
            ->whereStatus('1')
            ->get();

        $quizzes = Course::query()
            ->when($plan->category_id > 0, function ($q) use ($plan) {
                $q->whereHas('quiz',function ($qq) use ($plan){
                    return $qq->where('category_id', $plan->category_id);
                });
            })
            ->where('type', 2)
            ->whereStatus('1')
            ->get();

        $classes = Course::query()
            ->when($plan->category_id > 0, function ($q) use ($plan) {
                $q->whereHas('class',function ($qq) use ($plan){
                    return $qq->where('category_id', $plan->category_id);
                });
            })
            ->where('type', 3)
            ->whereStatus('1')
            ->get();
         $assigns = SubscriptionCourseList::where('plan_id', $id)->get();

        return view('subscription::assign.index', compact('plan', 'assigns', 'courses', 'quizzes', 'classes'));
    }


    public function add(Request $request)
    {

        if (demoCheck()) {
            return false;
        }
        try {
            if (!empty($request->element_id)) {
                foreach ($request->element_id as $data) {
                    $dpage = Course::findOrFail($data);

                    $check = SubscriptionCourseList::where('plan_id', $request->plan_id)
                        ->where('course_id', $data)->first();
                    if (!$check) {
                        $list = new SubscriptionCourseList();
                        $list->plan_id = $request->plan_id;
                        $list->course_id = $data;
                        $list->save();
                        $dpage->subscription = 1;
                        $dpage->save();
                    }
                }
            }
            return $this->reloadWithData($request->plan_id);
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
        }
    }


    public function delete(Request $request)
    {
        if (demoCheck()) {
            return false;
        }
        try {
            $element = SubscriptionCourseList::find($request->id);
            $plan = $element->plan_id;
            $element->delete();


            return $this->reloadWithData($plan);
        } catch (\Exception $e) {
            return response('error');
        }
    }

    private function reloadWithData($id)
    {
        $courses = Course::whereType(1)->whereStatus('1')->get();
        $quizzes = Course::whereType(2)->whereStatus('1')->get();
        $classes = Course::whereType(3)->whereStatus('1')->get();
        $assigns = SubscriptionCourseList::where('plan_id', $id)->get();


        return view('subscription::assign.list', compact(
            'courses', 'quizzes', 'classes', 'assigns'));


    }
}
