<?php

namespace Modules\Subscription\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Category;

class CourseSubscription extends Model
{
    use Tenantable;

    protected $guarded = ['id'];

    public function features()
    {
        return $this->hasMany(PlanFeature::class, 'plan_id', 'id');
    }

    public function assigns()
    {
        return $this->hasMany(SubscriptionCourseList::class, 'plan_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}
