<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Subscription\Entities\PlanFeature;

class CreatePlanFeaturesTable extends Migration
{

    public function up()
    {
        Schema::create('plan_features', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->integer('status')->default(1);
            $table->integer('order')->default(1);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });

        DB::table('plan_features')->insert([
            [
                'title' => 'Entire course library',
                'order' => 1
            ], [
                'title' => 'Learning paths',
                'order' => 2
            ], [
                'title' => 'Practice with exercise files and quizzes',
                'order' => 3
            ], [
                'title' => 'Interactive courses',
                'order' => 4
            ], [
                'title' => 'Earn a certificate when you complete a course',
                'order' => 5
            ], [
                'title' => 'Download to mobile app for offline viewing',
                'order' => 6
            ], [
                'title' => 'Course learning checks',
                'order' => 7
            ], [
                'title' => 'Course discussions',
                'order' => 8
            ]
        ]);

    }

    public function down()
    {
        Schema::dropIfExists('plan_features');
    }
}
