<form
    action="{{ isset($edit) ? route('store.pickuplocation.update', $edit->id) : route('store.pickuplocation.store') }}"
    method="POST" enctype="multipart/form-data" id="createForm">
    @csrf
    <div class="white_box p-15 box_shadow_white mb-20">
        <div class="box_header common_table_header">
            <div class="main-title d-md-flex">
                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ _trans('store.add_new_pickup_location') }}</h3>
            </div>
        </div>

        <div class="row">

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="pickup_location"> {{ _trans('store.pickup_location') }}
                        <span class="text-danger">*</span></label>
                    <input class="primary_input_field" name="pickup_location" id="pickup_location"
                           placeholder="{{ _trans('store.pickup_location') }}" type="text"
                           value="{{ isset($edit) ? $edit->pickup_location : old('pickup_location') }}">
                    <span class="text-danger" id="error_pickup_location"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="name"> {{ __('common.Name') }} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="name" id="name"
                           placeholder="{{ __('common.Name') }}" type="text"
                           value="{{ isset($edit) ? $edit->name : old('name') }}">
                    <span class="text-danger" id="error_name"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="email"> {{ __('common.Email') }} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="email" id="email"
                           placeholder="{{ __('common.Email') }}" type="text"
                           value="{{ isset($edit) ? $edit->email : old('email') }}">
                    <span class="text-danger" id="error_email"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="phone"> {{ __('common.Phone') }} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="phone" id="phone"
                           placeholder="{{ __('common.Phone') }}" type="number"
                           value="{{ isset($edit) ? $edit->phone : old('phone') }}">
                    <span class="text-danger" id="error_phone"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="address"> {{ __('common.Address') }} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="address" id="address"
                           placeholder="{{ __('common.Address') }}" type="text"
                           value="{{ isset($edit) ? $edit->address : old('address') }}">
                    <span class="text-danger" id="error_address"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="address_2"> {{ _trans('store.Address_2') }} </label>
                    <input class="primary_input_field" name="address_2" id="address_2"
                           placeholder="{{ _trans('store.Address_2') }}" type="text"
                           value="{{ isset($edit) ? $edit->address_2 : old('address_2') }}">
                    <span class="text-danger" id="error_address_2"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="pin_code"> {{ _trans('store.pin_code') }}
                        /{{ _trans('store.post_code') }} <span class="text-danger">*</span></label>
                    <input class="primary_input_field" name="pin_code" id="pin_code"
                           placeholder="{{ _trans('store.pin_code') }}/{{ _trans('store.post_code') }}" type="number"
                           value="{{ isset($edit) ? $edit->pin_code : old('pin_code') }}">
                    <span class="text-danger" id="error_pin_code"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="business_country">{{ _trans('store.country_region') }}
                        <span class="text-danger">*</span></label>
                    <select name="country_id" id="business_country" class="primary_select mb-25">
                        <option value="" disabled selected>{{ __('common.select_one') }}</option>
                        @if (isset($edit))
                            @foreach ($countries as $country)
                                <option {{ $edit->country_id == $country->id ? 'selected' : '' }}
                                        value="{{ $country->id }}">{{ $country->name }}</option>
                            @endforeach
                        @else
                            @foreach ($countries as $country)
                                <option {{ Settings('country_id') == $country->id ? 'selected' : '' }}
                                        value="{{ $country->id }}">{{ $country->name }}</option>
                            @endforeach
                        @endif

                    </select>
                    <span class="text-danger" id="error_country_id"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="business_state">{{ _trans('store.state') }} <span
                            class="text-danger">*</span></label>
                    <select name="state_id" id="business_state" class="primary_select mb-25">
                        <option value="" disabled selected>{{ __('common.select_one') }}</option>
                        @if (isset($edit))
                            @foreach ($states as $key => $state)
                                <option {{ $edit->state_id == $state->id ? 'selected' : '' }}
                                        value="{{ $state->id }}">{{ $state->name }}</option>
                            @endforeach
                        @else
                            @if (Settings('country_id'))
                                @foreach ($states as $key => $state)
                                    <option value="{{ $state->id }}">{{ $state->name }}</option>
                                @endforeach
                            @endif
                        @endif

                    </select>
                    <span class="text-danger" id="error_state_id"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="business_city">{{ _trans('store.city') }} </label>
                    <select name="city_id" id="business_city" class="primary_select mb-25">
                        <option value="" selected>{{ __('common.select_one') }}</option>
                        @if (isset($edit))
                            @foreach ($cities as $key => $city)
                                <option
                                    {{ $edit->city_id == $city->id ? 'selected':'' }} value="{{ $city->id }}">{{ $city->name }}</option>
                            @endforeach
                        @else
                            @foreach ($cities as $key => $city)
                                <option value="{{ $city->id }}">{{ $city->name }}</option>
                            @endforeach
                        @endif
                    </select>
                    <span class="text-danger" id="error_city_id"></span>
                </div>
            </div>

            <div class="col-lg-12 text-center">


                <div class="d-flex justify-content-center pt_20">
                    <button type="submit" class="primary-btn semi_large fix-gr-bg" data-bs-toggle="tooltip"
                            title="{{ @$tooltip }}" id="save_button_parent">
                        <i class=" fa fa-check "></i>

                        {{ isset($edit)?__('common.Update'):__('common.Save') }}
                    </button>


                </div>
            </div>
        </div>
    </div>
</form>
