@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('Modules/Store/Resources/assets/css/refund_style.css')}}"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css"/>
    <style>
        .logo_div img {
            height: 100px !important;
        }

        .product_img_div img {
            height: 100px;
        }
    </style>
@endpush
@section('mainContent')

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-8 student-details">
                    <div class=" white-box box_shadow_white" id="printableArea">
                        <div class="row pb-30 border-bottom">
                            <div class="col-md-6 col-lg-6">
                                <div class="logo_div">
                                    <img src="{{getLogoImage(Settings('logo'))}}" alt="">
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 text-end">
                                <h4><a class="a_tag_color"
                                       href="{{route('order_manage.show_details',$refund_request->order_id)}}"
                                       target="_blank">{{__('product.order_id')}}
                                        : {{ $refund_request->order->order_number }}</a></h4>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <div class="col-md-6 col-lg-6">
                                <table class="table-borderless clone_line_table">
                                    <tr>
                                        <td><strong>{{ __('product.refund_related_info') }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('common.Status') }}</td>
                                        <td>: {{ $refund_request->CheckConfirmed }}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('product.request_sent') }}</td>
                                        <td>: {{ $refund_request->created_at->format('d-m-Y h:i:s A') }}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('product.refund_method') }}</td>
                                        <td>: {{ strtoupper(str_replace("_"," ",$refund_request->refund_method)) }}</td>
                                    </tr>
                                    @if ($refund_request->refund_method == "bank_transfer")
                                        <tr>
                                            <td>{{ __('product.bank_name') }}</td>
                                            <td>: {{ $refund_request->bank_payments->bank_name }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.branch_name') }}</td>
                                            <td>: {{ $refund_request->bank_payments->branch_name }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.account_name') }}</td>
                                            <td>: {{ $refund_request->bank_payments->account_holder }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.account_nb') }}</td>
                                            <td>: {{ $refund_request->bank_payments->account_number }}</td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <td>{{ __('product.shipping_method') }}</td>
                                        <td>
                                            : {{ strtoupper(str_replace("_"," ",$refund_request->shipping_gateway->method_name)) }}</td>
                                    </tr>
                                </table>
                            </div>

                            @if ($refund_request->shipping_method == "courier")
                                <div class="col-md-6 col-lg-6">
                                    <table class="table-borderless clone_line_table">
                                        <tr>
                                            <td><strong>{{ __('product.pick_up_info') }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.shipping_gateway') }}</td>
                                            <td>: {{ @$refund_request->shipping_method }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Name') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->name }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Email') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->email }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Phone') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->phone }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('common.Address') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->address1 }}
                                                {{ @$refund_request->pick_up_address_customer->address2 }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>{{ __('product.state') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->stateDetails->name }}</td>
                                        </tr>

                                        <tr>
                                            <td>{{ __('product.city') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->cityDetails->name }}</td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.post_code') }}</td>
                                            <td>: {{ @$refund_request->pick_up_address_customer->zip_code }}</td>
                                        </tr>
                                    </table>
                                </div>
                            @else
                                <div class="col-md-6 col-lg-6">
                                    <table class="table-borderless clone_line_table">
                                        <tr>
                                            <td><strong>{{ __('product.drop_of_info') }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td>{{ __('product.Address') }}</td>
                                            <td>: {{ @$refund_request->drop_off_address }}</td>
                                        </tr>
                                    </table>
                                </div>
                            @endif
                        </div>
                        <div class="row mt-30">
                            @foreach ($refund_request->refund_details as $key => $refund_detail)
                                <div class="col-12 mt-30">
                                    <div class="box_header common_table_header">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ __('product.package') }}:
                                            {{ @$refund_detail->order_package->package_code }}
                                            <small>({{ @$refund_detail->process_refund->name }})</small>
                                        </h3>

                                    </div>
                                    <div class="QA_section QA_section_heading_custom check_box_table">
                                        <div class="QA_table ">
                                            <div class="table-responsive">
                                                <table class="table">
                                                    <tr>
                                                        <th scope="col">{{ __('common.Sl') }}</th>
                                                        <th scope="col">{{ __('product.Photo') }}</th>
                                                        <th scope="col">{{ __('common.Name') }}</th>
                                                        <th scope="col">{{ __('product.return_qty') }}</th>
                                                        <th scope="col">{{ __('product.total_amount') }}</th>
                                                        <th scope="col">{{ __('product.reason') }}</th>
                                                    </tr>
                                                    @foreach ($refund_detail->refund_products as $key => $package_product)
                                                        <tr>
                                                            <td>{{ $key+1 }}</td>
                                                            <td>
                                                                <div class="product_img_div">
                                                                    <img
                                                                        src="{{getCourseImage(@$package_product->product->thumbnail)}}"
                                                                        alt="#">
                                                                </div>
                                                            </td>
                                                            <td class="text-nowrap">
                                                                {{@$package_product->product->title}}
                                                            </td>
                                                            <td class="text-nowrap">{{ $package_product->return_qty }}</td>
                                                            <td class="text-nowrap">{{ single_price($package_product->return_amount) }}</td>
                                                            <td>{{ @$package_product->refund_reason->reason }}</td>
                                                        </tr>
                                                    @endforeach
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="row mt-30">
                            <div class="col-md-12">
                                <h5>{{ __('product.additional_info') }}</h5>
                                <p>{{ $refund_request->additional_info }}</p>
                            </div>
                            @if($refund_request->refund_images)
                                <div class="col-12">
                                    <div class="refund-images">
                                        @foreach($refund_request->refund_images as $refund_images)
                                            <div class="refund-image">
                                                <a href="{{getLogoImage($refund_images->image)}}"
                                                   data-fancybox="gallery">
                                                    <img src="{{getLogoImage($refund_images->image)}}">
                                                </a>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 student-details">
                    <form action="{{ route('refund.update_refund_detail_state_by_seller', $refund_detail->id) }}"
                          method="post">
                        @csrf
                        <div class="row white_box p-25 ms-0 me-0 box_shadow_white">
                            @if($refund_detail->refund_request->is_confirmed == 0)
                                <div class="col-lg-12">
                                    <div class="primary_input">
                                        <label class="primary_selectlabel alert alert-warning">
                                            {{__('product.status_is_changable_after_confirmed_the_refund_request')}}
                                        </label>
                                    </div>
                                </div>
                            @endif
                            <div class="col-lg-12 p-0">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">
                                        <strong>{{ __('product.processing_state') }}</strong> </label>
                                    <select required class="primary_select mb-25" name="processing_state"
                                            id="processing_state"
                                            @if($refund_detail->refund_request->is_confirmed == 0 || $refund_detail->refund_request->is_confirmed == 2 || $refund_detail->processing_state == 3) disabled @endif>
                                        <option value="">{{ __('common.select')}}</option>
                                        @foreach ($processes as $key => $process)
                                            <option value="{{ $process->id }}"
                                                    @if ($refund_detail->processing_state == $process->id) selected @endif>{{ $process->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                                @if($refund_detail->refund_request->is_confirmed == 0 || $refund_detail->refund_request->is_confirmed == 2 || $refund_detail->processing_state == 3)

                                    <div class="col-lg-12 p-0">
                                        <div class="d-flex justify-content-center  ">
                                            {{__('product.Unable to change status')}}

                                        </div>
                                    </div>
                                @else

                                    <div class="col-lg-12 p-0">
                                        <div class="d-flex justify-content-center  ">
                                            <button type="submit"
                                                    class="primary-btn semi_large fix-gr-bg"
                                                    id="save_button_parent">
                                                <i class="ti-check"></i>
                                                {{ __('common.Update') }}
                                            </button>
                                        </div>
                                    </div>
                                @endif

                        </div>
                    </form>
                </div>

            </div>
        </div>

    </section>

@endsection
@push("scripts")
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>
    <script type="text/javascript">
        (function ($) {
            "use Strict";

            function printDiv(divName) {
                var printContents = document.getElementById(divName).innerHTML;
                var originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                window.print();
                document.body.innerHTML = originalContents;
                setTimeout(function () {
                    window.location.reload();
                }, 15000);
            }

            $('[data-fancybox="gallery"]').fancybox({
                buttons: [
                    "slideShow",
                    "thumbs",
                    "zoom",
                    "fullScreen",
                    "share",
                    "close"
                ],
                loop: false,
                protect: true
            });
        })(jQuery);
    </script>
@endpush
