<table>
    <thead>
    <tr>
        <th scope="col"> {{ __('common.SL') }}</th>
        <th scope="col"> {{ __('common.Name') }}</th>
        <th scope="col"> {{ __('product.Product Type') }}</th>
        <th scope="col"> {{ __('product.Category') }}</th>
        <th scope="col"> {{ __('product.Brand') }}</th>
        <th scope="col"> {{ __('product.Price') }}</th>
    </tr>
    </thead>
    <tbody>

    @foreach ($products as $key => $item)
        <tr>
            <td class="text-start">{{ ++$key }}</td>
            <td>{{ $item->title }}</td>
            <td>
                {{ $item->type == 1 ? trans('product.Virtual') : trans('product.Physical') }}
            </td>
            <td>
                {{ @$item->category_id ? @$item->category->title : ''}}
            </td>
            <td>{{ @$item->brand_id ? @$item->brand->name : '' }}</td>
            <td>
                {{$item->discount_price != null?getPriceFormat($item->discount_price):getPriceFormat($item->price)}}
            </td>
        </tr>
    @endforeach

    </tbody>
</table>
