<?php

namespace Modules\Store\Repositories;

use Illuminate\Http\Request;
use Modules\Store\interfaces\CrudInterface;
use Illuminate\Support\Facades\Auth;
use App\Traits\ImageStore;
use Modules\Store\Entities\ProductAttribute;
use Modules\Store\Entities\ProductAttributeValue;

class ProductAttributeRepository implements CrudInterface
{
    use ImageStore;

    public function create(Request $request)

    {


        $attribute = new ProductAttribute ();

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->name as $key => $name) {
                $attribute->setTranslation('title', $key, $name);
            }
        } else {
            $attribute->title = $request->name;
        }

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->description as $key => $description) {
                $attribute->setTranslation('description', $key, $description);
            }
        } else {
            $attribute->description = $request->description;
        }


        $attribute->status = 1;
        $attribute->user_id = Auth::user()->id;
        $attribute->save();

        $count = sizeof($request->variant_values);
        if ($count > 1) {
            for ($i = 0; $i < sizeof($request->variant_values); $i++) {
                $attributevalue = new ProductAttributeValue();
                $attributevalue->product_attribute_id = $attribute->id;
                $attributevalue->value = $request->variant_values[$i];
                $attributevalue->save();
            }
        }

        return $attribute;
    }

    public function delete($id)
    {
        ProductAttributeValue::where('product_attribute_id', $id)->delete();
        $attribute = ProductAttribute::find($id)->delete();

        return $attribute;

    }

    public function update(Request $request)
    {


        $attribute = ProductAttribute::find($request->id);


        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->name as $key => $name) {
                $attribute->setTranslation('title', $key, $name);
            }
        } else {
            $attribute->title = $request->name;
        }

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->description as $key => $description) {
                $attribute->setTranslation('description', $key, $description);
            }
        } else {
            $attribute->description = $request->description;
        }


        $attribute->user_id = Auth::user()->id;
        $attribute->save();

        $collection1 = collect($request->edit_variant_values);
        $collection2 = collect($attribute->values->pluck('value', 'id'));
        $newDifferentItems = $collection1->diff($collection2);
        $new_variant_values = $newDifferentItems->all();

        if (count($new_variant_values) > 0) {

            for ($i = 0; $i < sizeof($request->edit_variant_values); $i++) {

                if (isset($request->value_id) && $request->value_id[$i] != 'null') {

                    $attri_value = ProductAttributeValue::find($request->value_id[$i]);

                    if ($attri_value) {

                        ProductAttributeValue::find($request->value_id[$i])->update(['value' => $request->edit_variant_values[$i]]);

                    }
                } else {
                    ProductAttributeValue::create([
                        'value' => $request->edit_variant_values[$i],
                        'product_attribute_id' => $attribute->id
                    ]);
                }
            }

        } else {
            $differentItems = $collection2->diff($collection1);
            $old_variant_values = $differentItems->all();
            if (count($old_variant_values) > 0) {
                foreach ($old_variant_values as $key => $old_variant_value) {

                    ProductAttributeValue::find($key)->delete();

                }
            }
        }
        return $attribute;
    }
}







